/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocument;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistory;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistoryDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistoryImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationHistoryPK;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameHistory;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class TaxonInformationHistoryDaoBase
extends HibernateDaoSupport
implements TaxonInformationHistoryDao {
    @Override
    public Object load(int transform, ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        TaxonInformationHistoryPK entityPk = new TaxonInformationHistoryPK();
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.load - 'referenceDocument' can not be null");
        }
        if (taxonNameHistory == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.load - 'taxonNameHistory' can not be null");
        }
        entityPk.setReferenceDocument(referenceDocument);
        entityPk.setTaxonNameHistory(taxonNameHistory);
        Object entity = this.getHibernateTemplate().get(TaxonInformationHistoryImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonInformationHistory)entity);
    }

    @Override
    public TaxonInformationHistory load(ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        return (TaxonInformationHistory)this.load(0, referenceDocument, taxonNameHistory);
    }

    @Override
    public Collection<TaxonInformationHistory> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonInformationHistoryImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonInformationHistory create(TaxonInformationHistory taxonInformationHistory) {
        return (TaxonInformationHistory)this.create(0, taxonInformationHistory);
    }

    @Override
    public Object create(int transform, TaxonInformationHistory taxonInformationHistory) {
        if (taxonInformationHistory == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.create - 'taxonInformationHistory' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonInformationHistory);
        return this.transformEntity(transform, taxonInformationHistory);
    }

    @Override
    public Collection<TaxonInformationHistory> create(Collection<TaxonInformationHistory> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonInformationHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonInformationHistoryDaoBase.this.create(transform, (TaxonInformationHistory)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonInformationHistory create(String description, Timestamp updateDate, ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        return (TaxonInformationHistory)this.create(0, description, updateDate, referenceDocument, taxonNameHistory);
    }

    @Override
    public Object create(int transform, String description, Timestamp updateDate, ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        TaxonInformationHistoryImpl entity = new TaxonInformationHistoryImpl();
        TaxonInformationHistoryPK entityPk = new TaxonInformationHistoryPK();
        entity.setTaxonInformationHistoryPk(entityPk);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entityPk.setReferenceDocument(referenceDocument);
        entityPk.setTaxonNameHistory(taxonNameHistory);
        return this.create(transform, entity);
    }

    @Override
    public TaxonInformationHistory create(ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        return (TaxonInformationHistory)this.create(0, referenceDocument, taxonNameHistory);
    }

    @Override
    public Object create(int transform, ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        TaxonInformationHistoryImpl entity = new TaxonInformationHistoryImpl();
        TaxonInformationHistoryPK entityPk = new TaxonInformationHistoryPK();
        entity.setTaxonInformationHistoryPk(entityPk);
        entityPk.setReferenceDocument(referenceDocument);
        entityPk.setTaxonNameHistory(taxonNameHistory);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonInformationHistory taxonInformationHistory) {
        if (taxonInformationHistory == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.update - 'taxonInformationHistory' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonInformationHistory);
    }

    @Override
    public void update(final Collection<TaxonInformationHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonInformationHistoryDaoBase.this.update((TaxonInformationHistory)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonInformationHistory taxonInformationHistory) {
        if (taxonInformationHistory == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.remove - 'taxonInformationHistory' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonInformationHistory);
    }

    @Override
    public void remove(ReferenceDocument referenceDocument, TaxonNameHistory taxonNameHistory) {
        TaxonInformationHistoryPK entityPk = new TaxonInformationHistoryPK();
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.remove - 'referenceDocument' can not be null");
        }
        entityPk.setReferenceDocument(referenceDocument);
        if (taxonNameHistory == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.remove - 'taxonNameHistory' can not be null");
        }
        entityPk.setTaxonNameHistory(taxonNameHistory);
        TaxonInformationHistory entity = this.load(referenceDocument, taxonNameHistory);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonInformationHistory> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformationHistory.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonInformationHistory entity) {
        TaxonInformationHistory target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonInformationHistory toEntity(Object[] row) {
        TaxonInformationHistory target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonInformationHistory)) continue;
                target = (TaxonInformationHistory)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonInformationHistoryImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonInformationHistoryImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonInformationHistory> search(Search search) {
        return this.search(0, search);
    }
}

