/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.survey.landing;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.measure.LandingMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingImpl;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingOrigin;
import fr.ifremer.adagio.core.dao.data.survey.sale.Sale;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Landing
implements Serializable {
    private static final long serialVersionUID = 4064224678316890273L;
    private Integer id;
    private String synchronizationStatus;
    private Date landingDateTime;
    private Short rankOrder;
    private String comments;
    private Date creationDate;
    private Date controlDate;
    private Date validationDate;
    private Date qualificationDate;
    private String qualificationComments;
    private Timestamp updateDate;
    private CatchBatch catchBatch;
    private Collection<Sale> sales = new HashSet<Sale>();
    private FishingTrip fishingTrip;
    private Location landingLocation;
    private Collection<LandingOrigin> landingOrigins = new HashSet<LandingOrigin>();
    private Department recorderDepartment;
    private Program program;
    private Vessel vessel;
    private Person recorderPerson;
    private QualityFlag qualityFlag;
    private Collection<LandingMeasurement> landingMeasurements = new HashSet<LandingMeasurement>();
    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();
    private Collection<Produce> produces = new HashSet<Produce>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    public void setSynchronizationStatus(String synchronizationStatus) {
        this.synchronizationStatus = synchronizationStatus;
    }

    public Date getLandingDateTime() {
        return this.landingDateTime;
    }

    public void setLandingDateTime(Date landingDateTime) {
        this.landingDateTime = landingDateTime;
    }

    public Short getRankOrder() {
        return this.rankOrder;
    }

    public void setRankOrder(Short rankOrder) {
        this.rankOrder = rankOrder;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getControlDate() {
        return this.controlDate;
    }

    public void setControlDate(Date controlDate) {
        this.controlDate = controlDate;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public Date getQualificationDate() {
        return this.qualificationDate;
    }

    public void setQualificationDate(Date qualificationDate) {
        this.qualificationDate = qualificationDate;
    }

    public String getQualificationComments() {
        return this.qualificationComments;
    }

    public void setQualificationComments(String qualificationComments) {
        this.qualificationComments = qualificationComments;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        this.catchBatch = catchBatch;
    }

    public Collection<Sale> getSales() {
        return this.sales;
    }

    public void setSales(Collection<Sale> sales) {
        this.sales = sales;
    }

    public FishingTrip getFishingTrip() {
        return this.fishingTrip;
    }

    public void setFishingTrip(FishingTrip fishingTrip) {
        this.fishingTrip = fishingTrip;
    }

    public Location getLandingLocation() {
        return this.landingLocation;
    }

    public void setLandingLocation(Location landingLocation) {
        this.landingLocation = landingLocation;
    }

    public Collection<LandingOrigin> getLandingOrigins() {
        return this.landingOrigins;
    }

    public void setLandingOrigins(Collection<LandingOrigin> landingOrigins) {
        this.landingOrigins = landingOrigins;
    }

    public Department getRecorderDepartment() {
        return this.recorderDepartment;
    }

    public void setRecorderDepartment(Department recorderDepartment) {
        this.recorderDepartment = recorderDepartment;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Vessel getVessel() {
        return this.vessel;
    }

    public void setVessel(Vessel vessel) {
        this.vessel = vessel;
    }

    public Person getRecorderPerson() {
        return this.recorderPerson;
    }

    public void setRecorderPerson(Person recorderPerson) {
        this.recorderPerson = recorderPerson;
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public void setQualityFlag(QualityFlag qualityFlag) {
        this.qualityFlag = qualityFlag;
    }

    public Collection<LandingMeasurement> getLandingMeasurements() {
        return this.landingMeasurements;
    }

    public void setLandingMeasurements(Collection<LandingMeasurement> landingMeasurements) {
        this.landingMeasurements = landingMeasurements;
    }

    public Collection<SurveyMeasurement> getSurveyMeasurements() {
        return this.surveyMeasurements;
    }

    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurements) {
        this.surveyMeasurements = surveyMeasurements;
    }

    public Collection<Produce> getProduces() {
        return this.produces;
    }

    public void setProduces(Collection<Produce> produces) {
        this.produces = produces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Landing)) {
            return false;
        }
        Landing that = (Landing)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Landing newInstance() {
            LandingImpl entity = new LandingImpl();
            return entity;
        }

        public static Landing newInstance(String synchronizationStatus, Date landingDateTime, Date creationDate, Location landingLocation, Department recorderDepartment, Program program, Vessel vessel, QualityFlag qualityFlag) {
            Landing entity = Factory.newInstance();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setLandingDateTime(landingDateTime);
            entity.setCreationDate(creationDate);
            entity.setLandingLocation(landingLocation);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        public static Landing newInstance(String synchronizationStatus, Date landingDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, CatchBatch catchBatch, Collection<Sale> sales, FishingTrip fishingTrip, Location landingLocation, Collection<LandingOrigin> landingOrigins, Department recorderDepartment, Program program, Vessel vessel, Person recorderPerson, QualityFlag qualityFlag, Collection<LandingMeasurement> landingMeasurements, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
            Landing entity = Factory.newInstance();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setLandingDateTime(landingDateTime);
            entity.setRankOrder(rankOrder);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setCatchBatch(catchBatch);
            entity.setSales(sales);
            entity.setFishingTrip(fishingTrip);
            entity.setLandingLocation(landingLocation);
            entity.setLandingOrigins(landingOrigins);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setRecorderPerson(recorderPerson);
            entity.setQualityFlag(qualityFlag);
            entity.setLandingMeasurements(landingMeasurements);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setProduces(produces);
            return entity;
        }
    }
}

