package fr.ifremer.tutti.ui.swing.util.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: TuttiActionUIHandler.java 586 2013-03-12 13:12:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/action/TuttiActionUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Container;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class TuttiActionUIHandler extends AbstractTuttiUIHandler<TuttiActionUIModel, TuttiActionUI> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(TuttiActionUIHandler.class);

    public TuttiActionUIHandler(TuttiUIContext context, TuttiActionUI ui) {
        super(context, ui);
    }

    protected PropertyChangeListener progressionListener = new PropertyChangeListener() {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {

            String propertyName = evt.getPropertyName();
            if (ProgressionModel.PROPERTY_MESSAGE.equals(propertyName)) {

                // change message
                ui.getTaskActionLabel().setText((String) evt.getNewValue());
            } else if (ProgressionModel.PROPERTY_TOTAL.equals(propertyName)) {

                // change total progressbar max
                ui.getTaskProgressBar().setMaximum((Integer) evt.getNewValue());

            } else if (ProgressionModel.PROPERTY_CURRENT.equals(propertyName)) {

                // change value of progress bar
                ui.getTaskProgressBar().setValue((Integer) evt.getNewValue());
            }
        }
    };

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    protected void hideAction() {
        ui.setVisible(false);
    }

    protected void showAction(AbstractTuttiAction action) {
        ui.getGlobalActionLabel().setText(
                _("tutti.message.action.running",
                  action.getActionDescription()));
        ui.pack();

        MainUI mainUI = getContext().getMainUI();
        if (mainUI != null) {
            Container component = mainUI.getBody();
            int width = component.getWidth();
            int height = component.getHeight();
            int x;
            int y;
            if (height == 0) {
                x = mainUI.getX() + 5;
                y = mainUI.getY() + 20;
            } else {
                x = mainUI.getX() + (mainUI.getWidth() - width);
                y = mainUI.getY() + (mainUI.getHeight() - height);
            }
            ui.setLocation(x, y);
        }
        ui.setVisible(true);
    }

    @Override
    public void beforeInitUI() {
        TuttiActionUIModel model = new TuttiActionUIModel();
        ui.setContextValue(model);

        model.addPropertyChangeListener(TuttiActionUIModel.PROPERTY_ACTION, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                // udpate global label
                AbstractTuttiAction action = (AbstractTuttiAction) evt.getNewValue();

                if (log.isDebugEnabled()) {
                    log.debug("Action to use: " + action);
                }
                if (action == null) {

                    // stoping action
                    hideAction();
                } else {

                    // starting action
                    showAction(action);
                }
            }
        });

        model.addPropertyChangeListener(TuttiActionUIModel.PROPERTY_PROGRESSION_MODEL, new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                // change progression model

                ProgressionModel oldValue = (ProgressionModel) evt.getOldValue();
                ProgressionModel newValue = (ProgressionModel) evt.getNewValue();

                if (log.isDebugEnabled()) {
                    log.debug("progression model: " + newValue);
                }
                if (oldValue != null) {
                    oldValue.removePropertyChangeListener(progressionListener);
                }

                if (newValue == null) {

                    // remove progression model
//                    ui.getGlobalProgressBar().setVisible(true);
                    ui.getTaskPanel().setVisible(false);
                } else {

                    // use progression model
//                    ui.getGlobalProgressBar().setVisible(false);
                    ui.getTaskPanel().setVisible(true);

                    newValue.addPropertyChangeListener(progressionListener);
                }
            }
        });
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        // installation layer de blocage en mode busy
        SwingUtil.setLayerUI(ui.getRootPanel(), ui.getBusyBlockLayerUI());

        ui.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    }

    @Override
    public void onCloseUI() {

    }

    @Override
    public SwingValidator<TuttiActionUIModel> getValidator() {
        return null;
    }

}
