package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportPupitriAction.java 694 2013-03-27 21:56:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/ImportPupitriAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.pupitri.TuttiPupitriImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.EditFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JOptionPane;
import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class ImportPupitriAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    private Log log = LogFactory.getLog(ImportPupitriAction.class);

    protected File importedTrunkFile;

    protected File importedCarrouselFile;

    protected File importedSpeciesFile;

    protected ImportPupitriPopupUI importPupitriDialog;

    protected TuttiProtocol currentProtocol;

    protected PersistenceService persistenceService;

    protected EditFishingOperationAction editAction;

    public ImportPupitriAction(EditCatchesUIHandler handler) {
        super(handler, false);
        persistenceService = getContext().getPersistenceService();
        importPupitriDialog = new ImportPupitriPopupUI(handler.getContext());
    }

    public EditFishingOperationAction getEditAction() {
        if (editAction == null) {
            editAction = TuttiActionHelper.createLogicAction(getHandler().getParentHandler(),
                                                             EditFishingOperationAction.class);
        }
        return editAction;
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result;

        if (!getContext().isProtocolFilled()) {
            result = false;

        } else {
            currentProtocol = getDataContext().getProtocol();
            result = currentProtocol != null && !currentProtocol.getSpecies().isEmpty();
        }

        if (!result) {
            JOptionPane.showMessageDialog(getContext().getActionUI(),
                                          _("tutti.editCatchBatch.action.importPupitri.noProtocol.message"),
                                          _("tutti.editCatchBatch.action.importPupitri.noProtocol.title"),
                                          JOptionPane.ERROR_MESSAGE);
        }

        SpeciesBatchUIModel speciesBatchUIModel = getUI().getSpeciesTabContent().getModel();
        if (result && speciesBatchUIModel.getRowCount() > 0) {
            String htmlMessage = String.format(
                    AbstractTuttiUIHandler.CONFIRMATION_FORMAT,
                    _("tutti.editCatchBatch.action.importPupitri.existingData.message"),
                    _("tutti.editCatchBatch.action.importPupitri.existingData.help"));

            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       htmlMessage,
                                                       _("tutti.editCatchBatch.action.importPupitri.existingData.title"),
                                                       JOptionPane.OK_CANCEL_OPTION,
                                                       JOptionPane.WARNING_MESSAGE);

            result = answer == JOptionPane.OK_OPTION;
        }

        if (result) {
            importPupitriDialog.open();
            importedTrunkFile = importPupitriDialog.getTrunkFile().getSelectedFile();
            importedCarrouselFile = importPupitriDialog.getCarrouselFile().getSelectedFile();
            importedSpeciesFile = importPupitriDialog.getSpeciesFile().getSelectedFile();
            result = importedTrunkFile != null
                     && importedCarrouselFile != null
                     && importedSpeciesFile != null;
        }

        return result;
    }

    @Override
    protected void doAction() throws Exception {
        TuttiPupitriImportExportService pupitriImportExportService =
                getContext().getTuttiPupitriImportExportService();

        EditCatchesUIModel model = getModel();

        FishingOperation operation = model.getFishingOperation();
        CatchBatch catchBatch = model.getCatchBatch();

        // import trunk
        pupitriImportExportService.importPupitri(importedTrunkFile,
                                                 importedCarrouselFile,
                                                 importedSpeciesFile,
                                                 operation,
                                                 catchBatch,
                                                 getDataContext().getReferentSpeciesWithSurveyCode());

        String fishingOperationText = getEditAction().getFishingOperationTitle(operation);

        getEditAction().loadCatchBatch(operation, fishingOperationText, true);

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage("TODO");
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        importedTrunkFile = null;
        importedCarrouselFile = null;
        currentProtocol = null;
    }

}
