/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol;

import com.ezware.oxbow.swingbits.util.Preconditions;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.protocol.TuttiProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.io.File;
import java.util.List;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ImportProtocolSpeciesAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ImportProtocolSpeciesAction.class);
    private File file;

    public ImportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, "import", I18n._((String)"tutti.action.importProtocolSpecies", (Object[])new Object[0]), I18n._((String)"tutti.action.importProtocolSpecies.tip", (Object[])new Object[0]), false);
    }

    @Override
    protected boolean prepareAction() {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = TuttiUIUtil.chooseFile(this.getContext().getMainUI(), I18n._((String)"tutti.title.choose.protocolSpeciesImportFile", (Object[])new Object[0]), I18n._((String)"tutti.action.chooseProtocolSpeciesFile", (Object[])new Object[0]), null, "^.*\\.csv", I18n._((String)"tutti.file.csv", (Object[])new Object[0]));
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        super.releaseAction();
        this.file = null;
    }

    @Override
    protected void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol species file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)((Object)this.getModel());
        TuttiProtocol protocol = (TuttiProtocol)model.toBean();
        TuttiProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.importProtocolSpecies(this.file, protocol, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        BeanComboBox<Species> speciesComboBox = ((EditProtocolUI)this.getUI()).getSpeciesComboBox();
        List<EditProtocolSpeciesRowModel> rows = ((EditProtocolUIHandler)this.handler).toRows(protocol.getSpecies());
        speciesComboBox.getHandler().sortData();
        ((EditProtocolUIHandler)this.handler).selectFirstInCombo(speciesComboBox);
        model.setRows(rows);
        this.sendMessage(I18n._((String)"tutti.flash.information.species.imported.in.protocol", (Object[])new Object[]{this.file}));
    }
}

