/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.gear;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.gear.GearDao;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class GearDaoBase
extends HibernateDaoSupport
implements GearDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Gear.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(GearImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Gear)entity);
    }

    @Override
    public Gear load(Integer id) {
        return (Gear)this.load(0, id);
    }

    @Override
    public Collection<Gear> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(GearImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Gear create(Gear gear) {
        return (Gear)this.create(0, gear);
    }

    @Override
    public Object create(int transform, Gear gear) {
        if (gear == null) {
            throw new IllegalArgumentException("Gear.create - 'gear' can not be null");
        }
        this.getHibernateTemplate().save((Object)gear);
        return this.transformEntity(transform, gear);
    }

    @Override
    public Collection<Gear> create(Collection<Gear> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Gear> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Gear.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    GearDaoBase.this.create(transform, (Gear)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Gear create(String label, String name, String description, Timestamp updateDate, GearClassification gearClassification, Collection<Gear> childGears, Gear parentGear, Status status) {
        return (Gear)this.create(0, label, name, description, updateDate, gearClassification, childGears, parentGear, status);
    }

    @Override
    public Object create(int transform, String label, String name, String description, Timestamp updateDate, GearClassification gearClassification, Collection<Gear> childGears, Gear parentGear, Status status) {
        GearImpl entity = new GearImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setGearClassification(gearClassification);
        entity.setChildGears(childGears);
        entity.setParentGear(parentGear);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public Gear create(GearClassification gearClassification, String label, String name, Status status) {
        return (Gear)this.create(0, gearClassification, label, name, status);
    }

    @Override
    public Object create(int transform, GearClassification gearClassification, String label, String name, Status status) {
        GearImpl entity = new GearImpl();
        entity.setGearClassification(gearClassification);
        entity.setLabel(label);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Gear gear) {
        if (gear == null) {
            throw new IllegalArgumentException("Gear.update - 'gear' can not be null");
        }
        this.getHibernateTemplate().update((Object)gear);
    }

    @Override
    public void update(final Collection<Gear> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Gear.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    GearDaoBase.this.update((Gear)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Gear gear) {
        if (gear == null) {
            throw new IllegalArgumentException("Gear.remove - 'gear' can not be null");
        }
        this.getHibernateTemplate().delete((Object)gear);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Gear.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Gear entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Gear> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Gear.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Gear entity) {
        Gear target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Gear toEntity(Object[] row) {
        Gear target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Gear)) continue;
                target = (Gear)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), GearImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), GearImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Gear> search(Search search) {
        return this.search(0, search);
    }
}

