/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao;

import fr.ifremer.adagio.core.dao.SearchParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Search
implements Serializable {
    private static final long serialVersionUID = 8277265070757689152L;
    private int pageNumber;
    private int pageSize;
    private Collection<SearchParameter> parameters = new ArrayList<SearchParameter>();
    private boolean eagerFetching;
    private boolean useSqlLimiting = false;

    public Search(SearchParameter[] parameters, int pageNumber, int pageSize, boolean eagerFetching) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        if (parameters != null) {
            this.parameters.addAll(Arrays.asList(parameters));
        }
        this.eagerFetching = eagerFetching;
    }

    public Search(SearchParameter[] parameters, int pageNumber, int pageSize) {
        this(parameters, pageNumber, pageSize, false);
    }

    public Search(SearchParameter[] parameters) {
        this(parameters, -1, -1, false);
    }

    public Search(SearchParameter[] parameters, boolean eagerFetching) {
        this(parameters, -1, -1, eagerFetching);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Search setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Search setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public SearchParameter[] getParameters() {
        return this.parameters.toArray(new SearchParameter[0]);
    }

    public Search setParameters(SearchParameter[] parameters) {
        this.parameters = new ArrayList<SearchParameter>(Arrays.asList(parameters));
        return this;
    }

    public Search() {
        this(null, -1, -1, false);
    }

    public Search addSearchParameter(SearchParameter searchParameter) {
        this.parameters.add(searchParameter);
        return this;
    }

    public boolean isEagerFetching() {
        return this.eagerFetching;
    }

    public Search setEagerFetching(boolean eagerFetching) {
        this.eagerFetching = eagerFetching;
        return this;
    }

    public Search addOrderBy(String propertyName) {
        return this.addOrderBy(propertyName, 0);
    }

    public Search addOrderBy(String propertyName, int order) {
        this.parameters.add(new SearchParameter(propertyName, null, -1, -1, order));
        return this;
    }

    public Search addOrderBy(String propertyName, boolean descending) {
        this.addOrderBy(propertyName, descending ? 1 : 0);
        return this;
    }

    public boolean isUseSqlLimiting() {
        return this.useSqlLimiting;
    }

    public Search setUseSqlLimiting(boolean useSqlPaging) {
        this.useSqlLimiting = useSqlPaging;
        return this;
    }
}

