/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import jaxx.runtime.validator.swing.SwingValidatorMessage;
import jaxx.runtime.validator.swing.SwingValidatorMessageListModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorScope;

public class SwingValidatorMessageListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 1L;
    protected String format = "%1$-20s - %2$s";
    protected String formatTip = "%1$-20s - %2$-20s :  %3$s";

    public SwingValidatorMessageListRenderer() {
    }

    public SwingValidatorMessageListRenderer(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel rendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        SwingValidatorMessage model = (SwingValidatorMessage)((Object)value);
        ImageIcon icon = SwingValidatorUtil.getIcon(model.getScope());
        String fieldName = this.getFieldName(list, model.getField(), index);
        String message = this.getMessage(model);
        String text = String.format(this.format, fieldName, message);
        String label = I18n._((String)model.getScope().getLabel(), (Object[])new Object[0]);
        String tmp = I18n._((String)"validator.scope.tip", (Object[])new Object[]{label});
        String tmp2 = I18n._((String)"validator.field.tip", (Object[])new Object[]{fieldName});
        String tooltTipText = String.format(this.formatTip, tmp, tmp2, message);
        rendererComponent.setText(text);
        rendererComponent.setToolTipText(tooltTipText);
        rendererComponent.setIcon(icon);
        return rendererComponent;
    }

    public ImageIcon getIcon(NuitonValidatorScope scope) {
        ImageIcon icon = SwingValidatorUtil.getIcon(scope);
        return icon;
    }

    public String getMessage(SwingValidatorMessage model) {
        String text = SwingValidatorUtil.getMessage(model);
        return text;
    }

    public String getFieldName(JList list, String value, int row) {
        SwingValidatorMessageListModel tableModel = (SwingValidatorMessageListModel)list.getModel();
        SwingValidatorMessage model = (SwingValidatorMessage)((Object)tableModel.getElementAt(row));
        String fieldName = SwingValidatorUtil.getFieldName(model, value);
        return fieldName;
    }
}

