/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class AttachmentCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AttachmentCellEditor.class);
    protected final AttachmentCellRenderer component;
    protected AttachmentEditor attachmentEditor;
    protected JTable table;
    protected AbstractTuttiTableModel<AbstractTuttiBeanUIModel> tableModel;
    protected ColumnIdentifier<AbstractTuttiBeanUIModel> columnIdentifier;
    protected AttachmentModelAware editRow;
    protected Integer rowIndex;
    protected Integer columnIndex;
    protected PropertyChangeListener reloadAttachmentEditorTextListener;

    public static TableCellEditor newEditor(TuttiUI ui, AttachmentCellRenderer renderer, AttachementObjectTypeEnum objectType) {
        Frame frame = (Frame)SwingUtil.getParentContainer((Object)ui, Frame.class);
        renderer.setBorder(new LineBorder(Color.BLACK));
        return new AttachmentCellEditor(frame, renderer, objectType);
    }

    public AttachmentCellEditor(Frame frame, AttachmentCellRenderer component, AttachementObjectTypeEnum objectTypeProperty) {
        this.component = component;
        this.reloadAttachmentEditorTextListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AttachmentCellEditor.this.tableModel.fireTableCellUpdated((int)AttachmentCellEditor.this.rowIndex, AttachmentCellEditor.this.columnIndex);
            }
        };
        this.attachmentEditor = new AttachmentEditor(frame, component, objectTypeProperty, I18n._((String)"tutti.table.accidental.batch.header.file", (Object[])new Object[0])){
            private static final long serialVersionUID = 1L;

            @Override
            protected AttachmentModelAware getBean() {
                return AttachmentCellEditor.this.editRow;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startEdit() {
                ((AbstractTuttiBeanUIModel)((Object)this.getBean())).addPropertyChangeListener("attachment", AttachmentCellEditor.this.reloadAttachmentEditorTextListener);
                try {
                    super.startEdit();
                    int r = AttachmentCellEditor.this.rowIndex;
                    int c = AttachmentCellEditor.this.columnIndex;
                    AttachmentCellEditor.this.stopCellEditing();
                    AttachmentCellEditor.this.tableModel.fireTableCellUpdated(r, c);
                    AbstractSelectTableAction.doSelectCell(AttachmentCellEditor.this.table, r, c);
                    AttachmentCellEditor.this.table.requestFocus();
                }
                finally {
                    ((AbstractTuttiBeanUIModel)((Object)this.getBean())).removePropertyChangeListener("attachment", AttachmentCellEditor.this.reloadAttachmentEditorTextListener);
                }
            }
        };
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        this.tableModel = (AbstractTuttiTableModel)table.getModel();
        this.columnIdentifier = this.tableModel.getPropertyName(column);
        this.rowIndex = row;
        this.columnIndex = column;
        this.editRow = (AttachmentModelAware)((Object)this.tableModel.getEntry(row));
        return this.component;
    }

    @Override
    public Object getCellEditorValue() {
        Preconditions.checkNotNull((Object)this.editRow, (Object)"No editRow found in editor.");
        String propertyName = this.columnIdentifier.getPropertyName();
        Object result = TuttiUIUtil.getProperty(this.editRow, propertyName);
        if (log.isInfoEnabled()) {
            log.info((Object)("editor value (" + propertyName + "): " + result));
        }
        return result;
    }

    @Override
    public boolean stopCellEditing() {
        boolean b = super.stopCellEditing();
        if (b) {
            this.rowIndex = null;
            this.editRow = null;
            this.columnIndex = null;
        }
        return b;
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
        this.rowIndex = null;
        this.columnIndex = null;
        this.editRow = null;
    }
}

