/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class BenthosBatchRowModel
extends AbstractTuttiBeanUIModel<SpeciesBatch, BenthosBatchRowModel>
implements AttachmentModelAware {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_SPECIES = "species";
    public static final String PROPERTY_SPECIES_TO_CONFIRM = "speciesToConfirm";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_NUMBER = "number";
    public static final String PROPERTY_SAMPLE_WEIGHT = "sampleWeight";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_ATTACHMENTS = "attachments";
    public static final String PROPERTY_PARENT_BATCH = "parentBatch";
    public static final String PROPERTY_CHILD_BATCH = "childBatch";
    public static final String PROPERTY_BATCH_LEAF = "batchLeaf";
    public static final String PROPERTY_BATCH_ROOT = "batchRoot";
    protected Species species;
    protected boolean speciesToConfirm;
    protected Float weight;
    protected Integer number;
    protected Float sampleWeight;
    protected String comment;
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected BenthosBatchRowModel parentBatch;
    protected List<BenthosBatchRowModel> childBatch;
    protected static final Binder<SpeciesBatch, BenthosBatchRowModel> fromBeanBinder = BinderFactory.newBinder(SpeciesBatch.class, BenthosBatchRowModel.class);
    protected static final Binder<BenthosBatchRowModel, SpeciesBatch> toBeanBinder = BinderFactory.newBinder(BenthosBatchRowModel.class, SpeciesBatch.class);

    public BenthosBatchRowModel() {
        super(SpeciesBatch.class, fromBeanBinder, toBeanBinder);
    }

    public BenthosBatchRowModel(SpeciesBatch aBatch) {
        this();
        this.fromBean(aBatch);
    }

    public Species getSpecies() {
        return this.species;
    }

    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        this.species = species;
        this.firePropertyChange(PROPERTY_SPECIES, oldValue, species);
    }

    public Boolean getSpeciesToConfirm() {
        return this.speciesToConfirm;
    }

    public void setSpeciesToConfirm(Boolean speciesToConfirm) {
        Boolean oldValue = this.getSpeciesToConfirm();
        this.speciesToConfirm = speciesToConfirm;
        this.firePropertyChange(PROPERTY_SPECIES_TO_CONFIRM, oldValue, speciesToConfirm);
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.weight = weight;
        this.firePropertyChange(PROPERTY_WEIGHT, oldValue, weight);
    }

    public Float getSampleWeight() {
        return this.sampleWeight;
    }

    public void setSampleWeight(Float sampleWeight) {
        Float oldValue = this.getSampleWeight();
        this.sampleWeight = sampleWeight;
        this.firePropertyChange(PROPERTY_SAMPLE_WEIGHT, oldValue, sampleWeight);
    }

    public BenthosBatchRowModel getParentBatch() {
        return this.parentBatch;
    }

    public void setParentBatch(BenthosBatchRowModel parentBatch) {
        BenthosBatchRowModel oldValue = this.getParentBatch();
        this.parentBatch = parentBatch;
        this.firePropertyChange(PROPERTY_PARENT_BATCH, oldValue, parentBatch);
        this.firePropertyChange(PROPERTY_BATCH_ROOT, null, this.isBatchRoot());
    }

    public List<BenthosBatchRowModel> getChildBatch() {
        return this.childBatch;
    }

    public void setChildBatch(List<BenthosBatchRowModel> childBatch) {
        this.childBatch = childBatch;
        this.firePropertyChange(PROPERTY_CHILD_BATCH, null, childBatch);
        this.firePropertyChange(PROPERTY_BATCH_LEAF, null, this.isBatchLeaf());
    }

    public boolean isBatchLeaf() {
        return CollectionUtils.isEmpty(this.childBatch);
    }

    public boolean isBatchRoot() {
        return this.parentBatch == null;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        Integer oldValue = this.getNumber();
        this.number = number;
        this.firePropertyChange(PROPERTY_NUMBER, oldValue, number);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.SAMPLE;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }
}

