/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunTutti {
    private static final Log log = LogFactory.getLog(RunTutti.class);
    public static final int UPATE_EXIT_CODE = 88;

    public static void main(String ... args) {
        TuttiUIContext context;
        block5: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting Tutti with arguments: " + Arrays.toString(args)));
            }
            Thread.setDefaultUncaughtExceptionHandler(new TuttiExceptionHandler());
            TuttiApplicationConfig config = new TuttiApplicationConfig("tutti.config", args);
            context = TuttiUIContext.newContext(config);
            context.init();
            if (config.isFullLaunchMode()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Full launch mode, try to update.");
                }
                MainUIHandler handler = new MainUIHandler(context);
                new UpdateApplicationAction(handler).performAndReleaseAction();
            }
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block5;
                log.warn((Object)"Failed to init nimbus look and feel");
            }
        }
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        RunTutti.startTutti(context);
    }

    public static void startTutti(TuttiUIContext context) {
        context.open();
        MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        mainUI.setVisible(true);
    }

    public static void closeTutti(MainUI ui, boolean exit) {
        ui.getHandler().getContext().getSwingSession().save();
        ui.getHandler().onCloseUI();
        ui.setVisible(false);
        ui.dispose();
        if (exit) {
            System.exit(0);
        }
    }
}

