/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti;

import fr.ifremer.tutti.TuttiTechnicalException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.nuiton.util.ZipUtil;

public class TuttiIOUtil {
    protected TuttiIOUtil() {
    }

    public static void close(Closeable toClose, String errorMessage) {
        try {
            toClose.close();
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void zip(File source, File archiveFile, String errorMessage) {
        try {
            ZipUtil.compress((File)archiveFile, (File)source);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void forceMkdir(File dir, String errorMessage) {
        try {
            FileUtils.forceMkdir((File)dir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void copyDirectory(File source, File target, String errorMessage) {
        try {
            FileUtils.copyDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void copyFileToDirectory(File source, File target, String errorMessage) {
        try {
            FileUtils.copyFileToDirectory((File)source, (File)target);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void copyFile(File source, File target, String errorMessage) {
        try {
            FileUtils.copyFile((File)source, (File)target);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static void deleteFile(File file, String errorMessage) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(errorMessage, e);
        }
    }

    public static File addExtensionIfMissing(File file, String extension) {
        if (!file.getName().endsWith(extension)) {
            file = new File(file.getParentFile(), file.getName() + extension);
        }
        return file;
    }

    public static String getExtension(File file) {
        return FilenameUtils.getExtension((String)file.getName());
    }
}

