package fr.ifremer.tutti.ui.swing.util.table;

/*
 * #%L
 * Tutti :: UI
 * $Id: MyIdentifierHighlightPredicate.java 500 2013-02-28 09:08:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/table/MyIdentifierHighlightPredicate.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * While using the swingX HighlightPredicate.IdentifierHighlightPredicate, it does not works very well with
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public class MyIdentifierHighlightPredicate implements HighlightPredicate {
    protected List<Object> columnList;

    /**
     * Instantiates a predicate which returns true for the
     * given column identifiers.
     *
     * @param columns the identitiers of the columns to highlight.
     */
    public MyIdentifierHighlightPredicate(Object... columns) {
        columnList = new ArrayList<Object>();
        Collections.addAll(columnList, columns);
    }

    /**
     * {@inheritDoc}
     * <p/>
     * This implementation returns true if the adapter's column
     * is contained in this predicates list.
     */
    @Override
    public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
//        int modelIndex = adapter.convertColumnIndexToModel(adapter.column);
        Object identifier = adapter.getColumnIdentifierAt(adapter.column);
        return identifier != null && columnList.contains(identifier);
    }

    /** @return the identifiers */
    public Object[] getIdentifiers() {
        if (columnList.isEmpty()) {
            return EMPTY_OBJECT_ARRAY;
        } else {
            return columnList.toArray(new Object[0]);
        }
    }

}