package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id: AttachmentEditorUIHandler.java 534 2013-03-05 10:45:23Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/attachment/AttachmentEditorUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.HBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;

/**
 * @author kmorin <morin@codelutin.com>
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class AttachmentEditorUIHandler {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(AttachmentEditorUIHandler.class);

    private final AttachmentEditorUI ui;

    private final PersistenceService persistenceService;

    public AttachmentEditorUIHandler(AttachmentEditorUI ui) {
        this.ui = ui;
        persistenceService =
                TuttiUIContext.getApplicationContext().getPersistenceService();


        this.ui.addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                init();
            }
        });
    }

    public void init() {
        resetFields();
        ui.getAttachments().removeAll();
        AttachmentModelAware bean = ui.getBean();
        if (bean != null) {
            List<Attachment> list = bean.getAttachment();
            if (list != null) {
                for (Attachment attachment : list) {
                    addAttachment(attachment);
                }
            }
        }
    }

    protected void addAttachment(final Attachment attachment) {
        final HBox hbox = new HBox();
        hbox.setVerticalAlignment(SwingConstants.CENTER);

        JButton deleteButton = new JButton(SwingUtil.createActionIcon("delete"));
        deleteButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentModelAware bean = ui.getBean();

                persistenceService.deleteAttachment(attachment.getId());

                bean.removeAttachment(attachment);

                ui.getAttachments().remove(hbox);

                JDialog parent = SwingUtil.getParentContainer(ui, JDialog.class);
                parent.pack();
            }
        });
        hbox.add(deleteButton);

        final JLabel label = new JLabel("<html><body><a href=''>"
                                        + attachment.getName() + "</a></body></html>");
        label.setToolTipText(attachment.getComment());
        label.addMouseListener(new MouseAdapter() {

            @Override
            public void mouseClicked(MouseEvent e) {
                File file = persistenceService.getAttachmentFile(attachment.getId());
                SwingUtil.openLink("file://" + file.getAbsolutePath());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setCursor(Cursor.getDefaultCursor());
            }

        });
        hbox.add(label);

        ui.getAttachments().add(hbox);
    }

    /** closes the editor */
    public void close() {
        if (log.isInfoEnabled()) {
            log.info("Will close UI " + ui);
        }
        SwingUtil.getParentContainer(ui, Window.class).dispose();
    }

    public void addAttachment() {
        AttachmentModelAware bean = ui.getBean();
        Attachment attachment = new Attachment();

        File file = ui.getFile().getSelectedFile();
        if (file != null) {
            String name = ui.getFileName().getText();
            if (StringUtils.isEmpty(name)) {
                name = file.getName();
            }
            attachment.setObjectType(ui.getObjectType());
            attachment.setObjectId(Integer.valueOf(String.valueOf(TuttiUIUtil.getProperty(bean, ui.getObjectIdProperty()))));
            attachment.setName(name);
            attachment.setComment(ui.getFileComment().getText());

            attachment = persistenceService.createAttachment(attachment, file);
            bean.addAttachment(attachment);

            resetFields();
            addAttachment(attachment);

            JDialog parent = SwingUtil.getParentContainer(ui, JDialog.class);
            parent.pack();
        }
    }

    protected void resetFields() {
        ui.getFile().setSelectedFile((File) null);
        ui.getFileName().setText("");
        ui.getFileComment().setText("");
    }

}
