package fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology;

/*
 * #%L
 * Tutti :: UI
 * $Id: HydrologyTableModel.java 512 2013-03-01 20:37:07Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/fishing/hydrology/HydrologyTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import org.jdesktop.swingx.table.TableColumnModelExt;

import static org.nuiton.i18n.I18n.n_;

/**
 * @author kmorin
 * @since 0.3
 */
public class HydrologyTableModel extends AbstractTuttiTableModel<HydrologyRowModel> {

    private static final long serialVersionUID = 1L;

    public static final ColumnIdentifier<HydrologyRowModel> KEY = ColumnIdentifier.newId(
            HydrologyRowModel.PROPERTY_KEY,
            n_("tutti.table.fishing.hydrology.header.key"),
            n_("tutti.table.fishing.hydrology.header.key"));

    public static final ColumnIdentifier<HydrologyRowModel> VALUE = ColumnIdentifier.newId(
            HydrologyRowModel.PROPERTY_VALUE,
            n_("tutti.table.fishing.hydrology.header.value"),
            n_("tutti.table.fishing.hydrology.header.value"));

//    public static final ColumnIdentifier<HydrologyRowModel> GEAR_SHOOTING_START_VALUE = ColumnIdentifier.newId(
//            HydrologyRowModel.PROPERTY_GEAR_SHOOTING_START_VALUE,
//            n_("tutti.table.fishing.hydrology.header.gearShootingStartValue"),
//            n_("tutti.table.fishing.hydrology.header.gearShootingStartValue"));
//
//    public static final ColumnIdentifier<HydrologyRowModel> GEAR_SHOOTING_END_VALUE = ColumnIdentifier.newId(
//            HydrologyRowModel.PROPERTY_GEAR_SHOOTING_END_VALUE,
//            n_("tutti.table.fishing.hydrology.header.gearShootingEndValue"),
//            n_("tutti.table.fishing.hydrology.header.gearShootingEndValue"));
//
//    public static final ColumnIdentifier<HydrologyRowModel> AVERAGE_VALUE = ColumnIdentifier.newId(
//            HydrologyRowModel.PROPERTY_AVERAGE_VALUE,
//            n_("tutti.table.fishing.hydrology.header.averageValue"),
//            n_("tutti.table.fishing.hydrology.header.averageValue"));

    public HydrologyTableModel(TableColumnModelExt columnModel) {
        super(columnModel, false, false);
        setNoneEditableCols(KEY);
    }

    @Override
    public HydrologyRowModel createNewRow() {
        HydrologyRowModel result = new HydrologyRowModel();
        return result;
    }

}
