package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.environment.EnvironmentTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.gearshooting.GearShootingTabUI;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.hydrology.HydrologyTabUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachmentEditor;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import fr.ifremer.tutti.ui.swing.util.editor.SimpleTimeEditor;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.TimeEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanListHeader;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditFishingOperationUI extends JPanel implements TuttiUI<EditFishingOperationUIModel, EditFishingOperationUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_ENABLED = "attachmentsButton.enabled";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DURATION_FIELD_TEXT = "durationField.text";
    public static final String BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED = "fishingOperationInvalidRadio.selected";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL = "fishingOperationNumberField.model";
    public static final String BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN = "fishingOperationNumberField.numberPattern";
    public static final String BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED = "fishingOperationRectiligneCheckBox.selected";
    public static final String BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED = "fishingOperationResetRadio.selected";
    public static final String BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED = "fishingOperationValidRadio.selected";
    public static final String BINDING_GEAR_COMBO_BOX_SELECTED_ITEM = "gearComboBox.selectedItem";
    public static final String BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE = "gearShootingEndDateField.date";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL = "gearShootingEndLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL = "gearShootingEndLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingEndLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingEndLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingEndLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingEndLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE = "gearShootingEndTimeField.date";
    public static final String BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE = "gearShootingStartDateField.date";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL = "gearShootingStartLatitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLatitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLatitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLatitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLatitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL = "gearShootingStartLongitudeDDField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMDDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMDDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMDMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMDMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL = "gearShootingStartLongitudeDMSDegreeField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSDegreeField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL = "gearShootingStartLongitudeDMSMinuteField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSMinuteField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL = "gearShootingStartLongitudeDMSSecondField.model";
    public static final String BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN = "gearShootingStartLongitudeDMSSecondField.numberPattern";
    public static final String BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE = "gearShootingStartTimeField.date";
    public static final String BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM = "locationComboBox.selectedItem";
    public static final String BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT = "multirigAggregationField.text";
    public static final String BINDING_STATION_NUMBER_FIELD_TEXT = "stationNumberField.text";
    public static final String BINDING_STRATA_COMBO_BOX_SELECTED_ITEM = "strataComboBox.selectedItem";
    public static final String BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM = "subStrataComboBox.selectedItem";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_ENABLED = "trawlDistanceField.enabled";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_MODEL = "trawlDistanceField.model";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN = "trawlDistanceField.numberPattern";
    public static final String BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT = "trawlDistanceField.toolTipText";
    public static final String BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM = "vesselComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditFishingOperationUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachmentEditor attachmentEditor;
    protected JButton attachmentsButton;
    protected JButton cancelButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JPanel createFishingOperationActions;
    protected JTextField durationField;
    protected JLabel durationLabel;
    protected TabInfo environmentTab;
    protected EnvironmentTabUI environmentTabContent;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JRadioButton fishingOperationInvalidRadio;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationNumber",  editorName = "fishingOperationNumberField")
    protected NumberEditor fishingOperationNumberField;
    protected JLabel fishingOperationNumberLabel;
    protected JPanel fishingOperationPane;
    protected JCheckBox fishingOperationRectiligneCheckBox;
    protected JRadioButton fishingOperationResetRadio;
    protected JTabbedPane fishingOperationTabPane;
    protected JAXXButtonGroup fishingOperationValid;
    @ValidatorField( validatorId = "validator",  propertyName = "fishingOperationValid",  editorName = "fishingOperationValidPanel")
    protected JToolBar fishingOperationValidPanel;
    protected JRadioButton fishingOperationValidRadio;
    protected Table gearCaracteristicsTable;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearComboBox")
    protected BeanComboBox<Gear> gearComboBox;
    protected JLabel gearDateLabel;
    protected JLabel gearLabel;
    protected JLabel gearLatitudeLabel;
    protected JLabel gearLongitudeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndDate",  editorName = "gearShootingEndDateField")
    protected JXDatePicker gearShootingEndDateField;
    protected JLabel gearShootingEndLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitude",  editorName = "gearShootingEndLatitudeDDField")
    protected NumberEditor gearShootingEndLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalDegree",  editorName = "gearShootingEndLatitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDecimalMinute",  editorName = "gearShootingEndLatitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeDegree",  editorName = "gearShootingEndLatitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeMinute",  editorName = "gearShootingEndLatitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLatitudeSecond",  editorName = "gearShootingEndLatitudeDMSSecondField")
    protected NumberEditor gearShootingEndLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLatitudeLayout;
    protected JPanel gearShootingEndLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitude",  editorName = "gearShootingEndLongitudeDDField")
    protected NumberEditor gearShootingEndLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalDegree",  editorName = "gearShootingEndLongitudeDMDDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDecimalMinute",  editorName = "gearShootingEndLongitudeDMDMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeDegree",  editorName = "gearShootingEndLongitudeDMSDegreeField")
    protected NumberEditor gearShootingEndLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeMinute",  editorName = "gearShootingEndLongitudeDMSMinuteField")
    protected NumberEditor gearShootingEndLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingEndLongitudeSecond",  editorName = "gearShootingEndLongitudeDMSSecondField")
    protected NumberEditor gearShootingEndLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingEndLongitudeLayout;
    protected JPanel gearShootingEndLongitudePanel;
    protected SimpleTimeEditor gearShootingEndTimeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartDate",  editorName = "gearShootingStartDateField")
    protected JXDatePicker gearShootingStartDateField;
    protected JLabel gearShootingStartLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitude",  editorName = "gearShootingStartLatitudeDDField")
    protected NumberEditor gearShootingStartLatitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalDegree",  editorName = "gearShootingStartLatitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDecimalMinute",  editorName = "gearShootingStartLatitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeDegree",  editorName = "gearShootingStartLatitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLatitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeMinute",  editorName = "gearShootingStartLatitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLatitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLatitudeSecond",  editorName = "gearShootingStartLatitudeDMSSecondField")
    protected NumberEditor gearShootingStartLatitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLatitudeLayout;
    protected JPanel gearShootingStartLatitudePanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitude",  editorName = "gearShootingStartLongitudeDDField")
    protected NumberEditor gearShootingStartLongitudeDDField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalDegree",  editorName = "gearShootingStartLongitudeDMDDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMDDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDecimalMinute",  editorName = "gearShootingStartLongitudeDMDMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMDMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeDegree",  editorName = "gearShootingStartLongitudeDMSDegreeField")
    protected NumberEditor gearShootingStartLongitudeDMSDegreeField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeMinute",  editorName = "gearShootingStartLongitudeDMSMinuteField")
    protected NumberEditor gearShootingStartLongitudeDMSMinuteField;
    @ValidatorField( validatorId = "validator",  propertyName = "gearShootingStartLongitudeSecond",  editorName = "gearShootingStartLongitudeDMSSecondField")
    protected NumberEditor gearShootingStartLongitudeDMSSecondField;
    protected CardLayout2Ext gearShootingStartLongitudeLayout;
    protected JPanel gearShootingStartLongitudePanel;
    protected SimpleTimeEditor gearShootingStartTimeField;
    protected GearShootingTabUI gearShootingTabContent;
    protected JLabel gearTimeLabel;
    protected Table generalForm;
    protected EditFishingOperationUIHandler handler;
    protected EditFishingOperationUI homePanel = this;
    protected HydrologyTabUI hydrologyTabContent;
    protected JButton importCasinoButton;
    @ValidatorField( validatorId = "validator",  propertyName = "location",  editorName = "locationComboBox")
    protected BeanComboBox<FishingOperationLocation> locationComboBox;
    protected JLabel locationLabel;
    protected EditFishingOperationUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigAggregation",  editorName = "multirigAggregationField")
    protected JTextField multirigAggregationField;
    protected JLabel multirigAggregationLabel;
    protected JButton resetValidStateButton;
    @ValidatorField( validatorId = "validator",  propertyName = "saisisseur",  editorName = "saisisseurList")
    protected BeanDoubleList<Person> saisisseurList;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "stationNumber",  editorName = "stationNumberField")
    protected JTextField stationNumberField;
    protected JLabel stationNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "strata",  editorName = "strataComboBox")
    protected BeanComboBox<FishingOperationLocation> strataComboBox;
    protected JLabel strataLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "subStrata",  editorName = "subStrataComboBox")
    protected BeanComboBox<FishingOperationLocation> subStrataComboBox;
    protected JLabel subStrataLabel;
    protected TabInfo traitGearShootingTab;
    protected TabInfo traitGeneralTab;
    protected TabInfo traitHydrologyTabContent;
    protected Table traitVesselPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "trawlDistance",  editorName = "trawlDistanceField")
    protected NumberEditor trawlDistanceField;
    protected JLabel trawlDistanceLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditFishingOperationUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselComboBox")
    protected BeanComboBox<Vessel> vesselComboBox;
    protected JLabel vesselLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private HBox $HBox0;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel10;
    private JPanel $JPanel11;
    private JPanel $JPanel12;
    private JPanel $JPanel13;
    private JPanel $JPanel14;
    private JPanel $JPanel15;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JPanel $JPanel6;
    private JPanel $JPanel7;
    private JPanel $JPanel8;
    private JPanel $JPanel9;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditFishingOperationUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditFishingOperationUIHandler handler = new EditFishingOperationUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI() {
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditFishingOperationUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditFishingOperationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__fishingOperationInvalidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.FALSE);
    }

    public void doActionPerformed__on__fishingOperationValidRadio(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(Boolean.TRUE);
    }

    public void doActionPerformed__on__gearShootingEndDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingEndDate");
    }

    public void doActionPerformed__on__gearShootingStartDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "gearShootingStartDate");
    }

    public void doActionPerformed__on__resetValidStateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setFishingOperationValid(null);
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doItemStateChanged__on__fishingOperationRectiligneCheckBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setBoolean(event, "fishingOperationRectiligne");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__multirigAggregationField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "multirigAggregation");
    }

    public void doKeyReleased__on__stationNumberField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "stationNumber");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachmentEditor getAttachmentEditor() {
        return attachmentEditor;
    }

    public JButton getAttachmentsButton() {
        return attachmentsButton;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JPanel getCreateFishingOperationActions() {
        return createFishingOperationActions;
    }

    public JTextField getDurationField() {
        return durationField;
    }

    public JLabel getDurationLabel() {
        return durationLabel;
    }

    public TabInfo getEnvironmentTab() {
        return environmentTab;
    }

    public EnvironmentTabUI getEnvironmentTabContent() {
        return environmentTabContent;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JRadioButton getFishingOperationInvalidRadio() {
        return fishingOperationInvalidRadio;
    }

    public NumberEditor getFishingOperationNumberField() {
        return fishingOperationNumberField;
    }

    public JLabel getFishingOperationNumberLabel() {
        return fishingOperationNumberLabel;
    }

    public JPanel getFishingOperationPane() {
        return fishingOperationPane;
    }

    public JCheckBox getFishingOperationRectiligneCheckBox() {
        return fishingOperationRectiligneCheckBox;
    }

    public JRadioButton getFishingOperationResetRadio() {
        return fishingOperationResetRadio;
    }

    public JTabbedPane getFishingOperationTabPane() {
        return fishingOperationTabPane;
    }

    public JAXXButtonGroup getFishingOperationValid() {
        return fishingOperationValid;
    }

    public JToolBar getFishingOperationValidPanel() {
        return fishingOperationValidPanel;
    }

    public JRadioButton getFishingOperationValidRadio() {
        return fishingOperationValidRadio;
    }

    public Table getGearCaracteristicsTable() {
        return gearCaracteristicsTable;
    }

    public BeanComboBox<Gear> getGearComboBox() {
        return gearComboBox;
    }

    public JLabel getGearDateLabel() {
        return gearDateLabel;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public JLabel getGearLatitudeLabel() {
        return gearLatitudeLabel;
    }

    public JLabel getGearLongitudeLabel() {
        return gearLongitudeLabel;
    }

    public JXDatePicker getGearShootingEndDateField() {
        return gearShootingEndDateField;
    }

    public JLabel getGearShootingEndLabel() {
        return gearShootingEndLabel;
    }

    public NumberEditor getGearShootingEndLatitudeDDField() {
        return gearShootingEndLatitudeDDField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDDegreeField() {
        return gearShootingEndLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMDMinuteField() {
        return gearShootingEndLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSDegreeField() {
        return gearShootingEndLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSMinuteField() {
        return gearShootingEndLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLatitudeDMSSecondField() {
        return gearShootingEndLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLatitudeLayout() {
        return gearShootingEndLatitudeLayout;
    }

    public JPanel getGearShootingEndLatitudePanel() {
        return gearShootingEndLatitudePanel;
    }

    public NumberEditor getGearShootingEndLongitudeDDField() {
        return gearShootingEndLongitudeDDField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDDegreeField() {
        return gearShootingEndLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMDMinuteField() {
        return gearShootingEndLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSDegreeField() {
        return gearShootingEndLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSMinuteField() {
        return gearShootingEndLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingEndLongitudeDMSSecondField() {
        return gearShootingEndLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingEndLongitudeLayout() {
        return gearShootingEndLongitudeLayout;
    }

    public JPanel getGearShootingEndLongitudePanel() {
        return gearShootingEndLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingEndTimeField() {
        return gearShootingEndTimeField;
    }

    public JXDatePicker getGearShootingStartDateField() {
        return gearShootingStartDateField;
    }

    public JLabel getGearShootingStartLabel() {
        return gearShootingStartLabel;
    }

    public NumberEditor getGearShootingStartLatitudeDDField() {
        return gearShootingStartLatitudeDDField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDDegreeField() {
        return gearShootingStartLatitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMDMinuteField() {
        return gearShootingStartLatitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSDegreeField() {
        return gearShootingStartLatitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSMinuteField() {
        return gearShootingStartLatitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLatitudeDMSSecondField() {
        return gearShootingStartLatitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLatitudeLayout() {
        return gearShootingStartLatitudeLayout;
    }

    public JPanel getGearShootingStartLatitudePanel() {
        return gearShootingStartLatitudePanel;
    }

    public NumberEditor getGearShootingStartLongitudeDDField() {
        return gearShootingStartLongitudeDDField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDDegreeField() {
        return gearShootingStartLongitudeDMDDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMDMinuteField() {
        return gearShootingStartLongitudeDMDMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSDegreeField() {
        return gearShootingStartLongitudeDMSDegreeField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSMinuteField() {
        return gearShootingStartLongitudeDMSMinuteField;
    }

    public NumberEditor getGearShootingStartLongitudeDMSSecondField() {
        return gearShootingStartLongitudeDMSSecondField;
    }

    public CardLayout2Ext getGearShootingStartLongitudeLayout() {
        return gearShootingStartLongitudeLayout;
    }

    public JPanel getGearShootingStartLongitudePanel() {
        return gearShootingStartLongitudePanel;
    }

    public SimpleTimeEditor getGearShootingStartTimeField() {
        return gearShootingStartTimeField;
    }

    public GearShootingTabUI getGearShootingTabContent() {
        return gearShootingTabContent;
    }

    public JLabel getGearTimeLabel() {
        return gearTimeLabel;
    }

    public Table getGeneralForm() {
        return generalForm;
    }

    public EditFishingOperationUIHandler getHandler() {
        return handler;
    }

    public HydrologyTabUI getHydrologyTabContent() {
        return hydrologyTabContent;
    }

    public JButton getImportCasinoButton() {
        return importCasinoButton;
    }

    public BeanComboBox<FishingOperationLocation> getLocationComboBox() {
        return locationComboBox;
    }

    public JLabel getLocationLabel() {
        return locationLabel;
    }

    public EditFishingOperationUIModel getModel() {
        return model;
    }

    public JTextField getMultirigAggregationField() {
        return multirigAggregationField;
    }

    public JLabel getMultirigAggregationLabel() {
        return multirigAggregationLabel;
    }

    public JButton getResetValidStateButton() {
        return resetValidStateButton;
    }

    public BeanDoubleList<Person> getSaisisseurList() {
        return saisisseurList;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getStationNumberField() {
        return stationNumberField;
    }

    public JLabel getStationNumberLabel() {
        return stationNumberLabel;
    }

    public BeanComboBox<FishingOperationLocation> getStrataComboBox() {
        return strataComboBox;
    }

    public JLabel getStrataLabel() {
        return strataLabel;
    }

    public BeanComboBox<FishingOperationLocation> getSubStrataComboBox() {
        return subStrataComboBox;
    }

    public JLabel getSubStrataLabel() {
        return subStrataLabel;
    }

    public TabInfo getTraitGearShootingTab() {
        return traitGearShootingTab;
    }

    public TabInfo getTraitGeneralTab() {
        return traitGeneralTab;
    }

    public TabInfo getTraitHydrologyTabContent() {
        return traitHydrologyTabContent;
    }

    public Table getTraitVesselPanel() {
        return traitVesselPanel;
    }

    public NumberEditor getTrawlDistanceField() {
        return trawlDistanceField;
    }

    public JLabel getTrawlDistanceLabel() {
        return trawlDistanceLabel;
    }

    public SwingValidator<EditFishingOperationUIModel> getValidator() {
        return validator;
    }

    public BeanComboBox<Vessel> getVesselComboBox() {
        return vesselComboBox;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel10() {
        return $JPanel10;
    }

    protected JPanel get$JPanel11() {
        return $JPanel11;
    }

    protected JPanel get$JPanel12() {
        return $JPanel12;
    }

    protected JPanel get$JPanel13() {
        return $JPanel13;
    }

    protected JPanel get$JPanel14() {
        return $JPanel14;
    }

    protected JPanel get$JPanel15() {
        return $JPanel15;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JPanel get$JPanel6() {
        return $JPanel6;
    }

    protected JPanel get$JPanel7() {
        return $JPanel7;
    }

    protected JPanel get$JPanel8() {
        return $JPanel8;
    }

    protected JPanel get$JPanel9() {
        return $JPanel9;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCreateFishingOperationActions() {
        if (!allComponentsCreated) {
            return;
        }
        createFishingOperationActions.add(cancelButton);
        createFishingOperationActions.add(saveButton);
    }

    protected void addChildrenToFishingOperationInvalidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationInvalidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationInvalidRadio); }
    }

    protected void addChildrenToFishingOperationPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationPane.add(fishingOperationTabPane, BorderLayout.CENTER);
        fishingOperationPane.add($JPanel15, BorderLayout.SOUTH);
    }

    protected void addChildrenToFishingOperationResetRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationResetRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationResetRadio); }
    }

    protected void addChildrenToFishingOperationTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationTabPane.add(generalForm);
        fishingOperationTabPane.add(gearShootingTabContent);
        fishingOperationTabPane.add(environmentTabContent);
        fishingOperationTabPane.add(hydrologyTabContent);
        traitGeneralTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 0));
        traitGearShootingTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 1));
        environmentTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 2));
        traitHydrologyTabContent.addPropertyChangeListener(new TabInfoPropertyChangeListener(fishingOperationTabPane, 3));
    }

    protected void addChildrenToFishingOperationValidPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fishingOperationValidPanel.add(resetValidStateButton, BorderLayout.WEST);
        fishingOperationValidPanel.add(fishingOperationResetRadio, BorderLayout.EAST);
    }

    protected void addChildrenToFishingOperationValidRadio() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = fishingOperationValid; fishingOperationValidRadio.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(fishingOperationValidRadio); }
    }

    protected void addChildrenToGearCaracteristicsTable() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsTable.add($JPanel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLatitudeLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearLongitudeLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearDateLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearTimeLabel, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLatitudePanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartLongitudePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartDateField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingStartTimeField, new GridBagConstraints(4, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLatitudePanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndLongitudePanel, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndDateField), new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(gearShootingEndTimeField, new GridBagConstraints(4, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel0, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(fishingOperationRectiligneCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel10, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JLabel1, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel11, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add(SwingUtil.boxComponentWithJxLayer(fishingOperationValidPanel), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($HBox0, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        gearCaracteristicsTable.add($JPanel12, new GridBagConstraints(2, 4, 4, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToGearShootingEndLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDDField), "DD");
        gearShootingEndLatitudePanel.add($JPanel6, "DMS");
        gearShootingEndLatitudePanel.add($JPanel7, "DMD");
    }

    protected void addChildrenToGearShootingEndLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingEndLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDDField), "DD");
        gearShootingEndLongitudePanel.add($JPanel8, "DMS");
        gearShootingEndLongitudePanel.add($JPanel9, "DMD");
    }

    protected void addChildrenToGearShootingStartLatitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLatitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDDField), "DD");
        gearShootingStartLatitudePanel.add($JPanel2, "DMS");
        gearShootingStartLatitudePanel.add($JPanel3, "DMD");
    }

    protected void addChildrenToGearShootingStartLongitudePanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearShootingStartLongitudePanel.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDDField), "DD");
        gearShootingStartLongitudePanel.add($JPanel4, "DMS");
        gearShootingStartLongitudePanel.add($JPanel5, "DMD");
    }

    protected void addChildrenToGeneralForm() {
        if (!allComponentsCreated) {
            return;
        }
        generalForm.add(stationNumberLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(stationNumberField), new GridBagConstraints(1, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(fishingOperationNumberLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(fishingOperationNumberField), new GridBagConstraints(3, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(multirigAggregationLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(multirigAggregationField), new GridBagConstraints(5, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(strataLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(strataComboBox), new GridBagConstraints(1, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(subStrataLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(subStrataComboBox), new GridBagConstraints(3, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(locationLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(locationComboBox), new GridBagConstraints(5, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel0, new GridBagConstraints(0, 2, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel13, new GridBagConstraints(0, 3, 6, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add($JPanel14, new GridBagConstraints(0, 4, 6, 1, 0.0, 0.2, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        generalForm.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 5, 6, 1, 0.0, 0.8, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(fishingOperationPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTraitVesselPanel() {
        if (!allComponentsCreated) {
            return;
        }
        traitVesselPanel.add(vesselLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(vesselComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(gearLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        traitVesselPanel.add(SwingUtil.boxComponentWithJxLayer(gearComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = ButtonAttachmentEditor.newEditor(this, attachmentsButton));
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new JButton());
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.putClientProperty("tuttiAction", CancelEditFishingOperationAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.label.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
    }

    protected void createCreateFishingOperationActions() {
        $objectMap.put("createFishingOperationActions", createFishingOperationActions = new JPanel());
        
        createFishingOperationActions.setName("createFishingOperationActions");
        createFishingOperationActions.setLayout(new GridLayout(1,0));
    }

    protected void createDurationField() {
        $objectMap.put("durationField", durationField = new JTextField());
        
        durationField.setName("durationField");
        durationField.setColumns(15);
        durationField.setEnabled(false);
        durationField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.duration"));
    }

    protected void createDurationLabel() {
        $objectMap.put("durationLabel", durationLabel = new JLabel());
        
        durationLabel.setName("durationLabel");
        durationLabel.setText(_("tutti.label.fishingOperation.duration"));
    }

    protected void createEnvironmentTab() {
        $objectMap.put("environmentTab", environmentTab = new TabInfo());
    }

    protected void createEnvironmentTabContent() {
        $objectMap.put("environmentTabContent", environmentTabContent = new EnvironmentTabUI(this));
        
        environmentTabContent.setName("environmentTabContent");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationInvalidRadio() {
        $objectMap.put("fishingOperationInvalidRadio", fishingOperationInvalidRadio = new JRadioButton());
        
        fishingOperationInvalidRadio.setName("fishingOperationInvalidRadio");
        fishingOperationInvalidRadio.setText(_("tutti.label.fishingOperation.fishingOperationInvalid"));
        fishingOperationInvalidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationInvalidRadio"));
    }

    protected void createFishingOperationNumberField() {
        $objectMap.put("fishingOperationNumberField", fishingOperationNumberField = new NumberEditor(this));
        
        fishingOperationNumberField.setName("fishingOperationNumberField");
        fishingOperationNumberField.setProperty("fishingOperationNumber");
        fishingOperationNumberField.setUseFloat(false);
        fishingOperationNumberField.setShowReset(true);
        fishingOperationNumberField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.fishingOperationNumber"));
    }

    protected void createFishingOperationNumberLabel() {
        $objectMap.put("fishingOperationNumberLabel", fishingOperationNumberLabel = new JLabel());
        
        fishingOperationNumberLabel.setName("fishingOperationNumberLabel");
        fishingOperationNumberLabel.setText(_("tutti.label.fishingOperation.fishingOperationNumber"));
    }

    protected void createFishingOperationPane() {
        $objectMap.put("fishingOperationPane", fishingOperationPane = new JPanel());
        
        fishingOperationPane.setName("fishingOperationPane");
        fishingOperationPane.setLayout(new BorderLayout());
    }

    protected void createFishingOperationRectiligneCheckBox() {
        $objectMap.put("fishingOperationRectiligneCheckBox", fishingOperationRectiligneCheckBox = new JCheckBox());
        
        fishingOperationRectiligneCheckBox.setName("fishingOperationRectiligneCheckBox");
        fishingOperationRectiligneCheckBox.setText(_("tutti.label.fishingOperation.fishingOperationRectiligne"));
        fishingOperationRectiligneCheckBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fishingOperationRectiligneCheckBox"));
    }

    protected void createFishingOperationResetRadio() {
        $objectMap.put("fishingOperationResetRadio", fishingOperationResetRadio = new JRadioButton());
        
        fishingOperationResetRadio.setName("fishingOperationResetRadio");
    }

    protected void createFishingOperationTabPane() {
        $objectMap.put("fishingOperationTabPane", fishingOperationTabPane = new JTabbedPane());
        
        fishingOperationTabPane.setName("fishingOperationTabPane");
    }

    protected void createFishingOperationValid() {
        $objectMap.put("fishingOperationValid", fishingOperationValid = new JAXXButtonGroup());
    }

    protected void createFishingOperationValidPanel() {
        $objectMap.put("fishingOperationValidPanel", fishingOperationValidPanel = new JToolBar());
        
        fishingOperationValidPanel.setName("fishingOperationValidPanel");
        fishingOperationValidPanel.setLayout(new BorderLayout());
        fishingOperationValidPanel.setFloatable(false);
        fishingOperationValidPanel.setOpaque(false);
        fishingOperationValidPanel.setBorderPainted(false);
        fishingOperationValidPanel.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.fishingOperationValidity"));
    }

    protected void createFishingOperationValidRadio() {
        $objectMap.put("fishingOperationValidRadio", fishingOperationValidRadio = new JRadioButton());
        
        fishingOperationValidRadio.setName("fishingOperationValidRadio");
        fishingOperationValidRadio.setText(_("tutti.label.fishingOperation.fishingOperationValid"));
        fishingOperationValidRadio.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__fishingOperationValidRadio"));
    }

    protected void createGearCaracteristicsTable() {
        $objectMap.put("gearCaracteristicsTable", gearCaracteristicsTable = new Table());
        
        gearCaracteristicsTable.setName("gearCaracteristicsTable");
    }

    protected void createGearComboBox() {
        $objectMap.put("gearComboBox", gearComboBox = new BeanComboBox<Gear>(this));
        
        gearComboBox.setName("gearComboBox");
        gearComboBox.setI18nPrefix("tutti.property.");
        gearComboBox.setProperty("gear");
        gearComboBox.setShowReset(true);
        gearComboBox.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gear"));
    }

    protected void createGearDateLabel() {
        $objectMap.put("gearDateLabel", gearDateLabel = new JLabel());
        
        gearDateLabel.setName("gearDateLabel");
        gearDateLabel.setText(_("tutti.label.fishingOperation.gearDate"));
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(_("tutti.label.fishingOperation.gear"));
    }

    protected void createGearLatitudeLabel() {
        $objectMap.put("gearLatitudeLabel", gearLatitudeLabel = new JLabel());
        
        gearLatitudeLabel.setName("gearLatitudeLabel");
    }

    protected void createGearLongitudeLabel() {
        $objectMap.put("gearLongitudeLabel", gearLongitudeLabel = new JLabel());
        
        gearLongitudeLabel.setName("gearLongitudeLabel");
    }

    protected void createGearShootingEndDateField() {
        $objectMap.put("gearShootingEndDateField", gearShootingEndDateField = new JXDatePicker());
        
        gearShootingEndDateField.setName("gearShootingEndDateField");
        gearShootingEndDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingEndDateField"));
        gearShootingEndDateField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndDate"));
    }

    protected void createGearShootingEndLabel() {
        $objectMap.put("gearShootingEndLabel", gearShootingEndLabel = new JLabel());
        
        gearShootingEndLabel.setName("gearShootingEndLabel");
        gearShootingEndLabel.setText(_("tutti.label.fishingOperation.gearShootingEnd"));
    }

    protected void createGearShootingEndLatitudeDDField() {
        $objectMap.put("gearShootingEndLatitudeDDField", gearShootingEndLatitudeDDField = new NumberEditor(this));
        
        gearShootingEndLatitudeDDField.setName("gearShootingEndLatitudeDDField");
        gearShootingEndLatitudeDDField.setUseSign(true);
        gearShootingEndLatitudeDDField.setProperty("gearShootingEndLatitude");
        gearShootingEndLatitudeDDField.setUseFloat(true);
        gearShootingEndLatitudeDDField.setShowReset(false);
        gearShootingEndLatitudeDDField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitude"));
    }

    protected void createGearShootingEndLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMDDegreeField", gearShootingEndLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDDegreeField.setName("gearShootingEndLatitudeDMDDegreeField");
        gearShootingEndLatitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMDDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitudeDegree"));
    }

    protected void createGearShootingEndLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMDMinuteField", gearShootingEndLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMDMinuteField.setName("gearShootingEndLatitudeDMDMinuteField");
        gearShootingEndLatitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMDMinuteField.setProperty("gearShootingEndLatitudeDecimalMinute");
        gearShootingEndLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLatitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitudeMinute"));
    }

    protected void createGearShootingEndLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLatitudeDMSDegreeField", gearShootingEndLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSDegreeField.setName("gearShootingEndLatitudeDMSDegreeField");
        gearShootingEndLatitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLatitudeDMSDegreeField.setProperty("gearShootingEndLatitudeDegree");
        gearShootingEndLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLatitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitudeDegree"));
    }

    protected void createGearShootingEndLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLatitudeDMSMinuteField", gearShootingEndLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSMinuteField.setName("gearShootingEndLatitudeDMSMinuteField");
        gearShootingEndLatitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLatitudeDMSMinuteField.setProperty("gearShootingEndLatitudeMinute");
        gearShootingEndLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLatitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitudeMinute"));
    }

    protected void createGearShootingEndLatitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLatitudeDMSSecondField", gearShootingEndLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLatitudeDMSSecondField.setName("gearShootingEndLatitudeDMSSecondField");
        gearShootingEndLatitudeDMSSecondField.setUseSign(false);
        gearShootingEndLatitudeDMSSecondField.setProperty("gearShootingEndLatitudeSecond");
        gearShootingEndLatitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLatitudeDMSSecondField.setShowReset(false);
        gearShootingEndLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLatitudeSecond"));
    }

    protected void createGearShootingEndLatitudeLayout() {
        $objectMap.put("gearShootingEndLatitudeLayout", gearShootingEndLatitudeLayout = new CardLayout2Ext(this, "gearShootingEndLatitudePanel"));
    }

    protected void createGearShootingEndLatitudePanel() {
        $objectMap.put("gearShootingEndLatitudePanel", gearShootingEndLatitudePanel = new JPanel());
        
        gearShootingEndLatitudePanel.setName("gearShootingEndLatitudePanel");
        gearShootingEndLatitudePanel.setLayout(gearShootingEndLatitudeLayout);
    }

    protected void createGearShootingEndLongitudeDDField() {
        $objectMap.put("gearShootingEndLongitudeDDField", gearShootingEndLongitudeDDField = new NumberEditor(this));
        
        gearShootingEndLongitudeDDField.setName("gearShootingEndLongitudeDDField");
        gearShootingEndLongitudeDDField.setUseSign(true);
        gearShootingEndLongitudeDDField.setProperty("gearShootingEndLongitude");
        gearShootingEndLongitudeDDField.setUseFloat(true);
        gearShootingEndLongitudeDDField.setShowReset(false);
        gearShootingEndLongitudeDDField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitude"));
    }

    protected void createGearShootingEndLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMDDegreeField", gearShootingEndLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDDegreeField.setName("gearShootingEndLongitudeDMDDegreeField");
        gearShootingEndLongitudeDMDDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMDDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMDDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitudeDegree"));
    }

    protected void createGearShootingEndLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMDMinuteField", gearShootingEndLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMDMinuteField.setName("gearShootingEndLongitudeDMDMinuteField");
        gearShootingEndLongitudeDMDMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMDMinuteField.setProperty("gearShootingEndLongitudeDecimalMinute");
        gearShootingEndLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingEndLongitudeDMDMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitudeMinute"));
    }

    protected void createGearShootingEndLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingEndLongitudeDMSDegreeField", gearShootingEndLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSDegreeField.setName("gearShootingEndLongitudeDMSDegreeField");
        gearShootingEndLongitudeDMSDegreeField.setUseSign(true);
        gearShootingEndLongitudeDMSDegreeField.setProperty("gearShootingEndLongitudeDegree");
        gearShootingEndLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingEndLongitudeDMSDegreeField.setShowReset(false);
        gearShootingEndLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitudeDegree"));
    }

    protected void createGearShootingEndLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingEndLongitudeDMSMinuteField", gearShootingEndLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSMinuteField.setName("gearShootingEndLongitudeDMSMinuteField");
        gearShootingEndLongitudeDMSMinuteField.setUseSign(false);
        gearShootingEndLongitudeDMSMinuteField.setProperty("gearShootingEndLongitudeMinute");
        gearShootingEndLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingEndLongitudeDMSMinuteField.setShowReset(false);
        gearShootingEndLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitudeMinute"));
    }

    protected void createGearShootingEndLongitudeDMSSecondField() {
        $objectMap.put("gearShootingEndLongitudeDMSSecondField", gearShootingEndLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingEndLongitudeDMSSecondField.setName("gearShootingEndLongitudeDMSSecondField");
        gearShootingEndLongitudeDMSSecondField.setUseSign(false);
        gearShootingEndLongitudeDMSSecondField.setProperty("gearShootingEndLongitudeSecond");
        gearShootingEndLongitudeDMSSecondField.setUseFloat(false);
        gearShootingEndLongitudeDMSSecondField.setShowReset(false);
        gearShootingEndLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingEndLongitudeSecond"));
    }

    protected void createGearShootingEndLongitudeLayout() {
        $objectMap.put("gearShootingEndLongitudeLayout", gearShootingEndLongitudeLayout = new CardLayout2Ext(this, "gearShootingEndLongitudePanel"));
    }

    protected void createGearShootingEndLongitudePanel() {
        $objectMap.put("gearShootingEndLongitudePanel", gearShootingEndLongitudePanel = new JPanel());
        
        gearShootingEndLongitudePanel.setName("gearShootingEndLongitudePanel");
        gearShootingEndLongitudePanel.setLayout(gearShootingEndLongitudeLayout);
    }

    protected void createGearShootingEndTimeField() {
        $objectMap.put("gearShootingEndTimeField", gearShootingEndTimeField = new SimpleTimeEditor(this));
        
        gearShootingEndTimeField.setName("gearShootingEndTimeField");
        gearShootingEndTimeField.setProperty("gearShootingEndTime");
    }

    protected void createGearShootingStartDateField() {
        $objectMap.put("gearShootingStartDateField", gearShootingStartDateField = new JXDatePicker());
        
        gearShootingStartDateField.setName("gearShootingStartDateField");
        gearShootingStartDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__gearShootingStartDateField"));
        gearShootingStartDateField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartDate"));
    }

    protected void createGearShootingStartLabel() {
        $objectMap.put("gearShootingStartLabel", gearShootingStartLabel = new JLabel());
        
        gearShootingStartLabel.setName("gearShootingStartLabel");
        gearShootingStartLabel.setText(_("tutti.label.fishingOperation.gearShootingStart"));
    }

    protected void createGearShootingStartLatitudeDDField() {
        $objectMap.put("gearShootingStartLatitudeDDField", gearShootingStartLatitudeDDField = new NumberEditor(this));
        
        gearShootingStartLatitudeDDField.setName("gearShootingStartLatitudeDDField");
        gearShootingStartLatitudeDDField.setUseSign(true);
        gearShootingStartLatitudeDDField.setProperty("gearShootingStartLatitude");
        gearShootingStartLatitudeDDField.setUseFloat(true);
        gearShootingStartLatitudeDDField.setShowReset(false);
        gearShootingStartLatitudeDDField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitude"));
    }

    protected void createGearShootingStartLatitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMDDegreeField", gearShootingStartLatitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDDegreeField.setName("gearShootingStartLatitudeDMDDegreeField");
        gearShootingStartLatitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMDDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitudeDegree"));
    }

    protected void createGearShootingStartLatitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMDMinuteField", gearShootingStartLatitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMDMinuteField.setName("gearShootingStartLatitudeDMDMinuteField");
        gearShootingStartLatitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMDMinuteField.setProperty("gearShootingStartLatitudeDecimalMinute");
        gearShootingStartLatitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLatitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitudeMinute"));
    }

    protected void createGearShootingStartLatitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLatitudeDMSDegreeField", gearShootingStartLatitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSDegreeField.setName("gearShootingStartLatitudeDMSDegreeField");
        gearShootingStartLatitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLatitudeDMSDegreeField.setProperty("gearShootingStartLatitudeDegree");
        gearShootingStartLatitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLatitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLatitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitudeDegree"));
    }

    protected void createGearShootingStartLatitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLatitudeDMSMinuteField", gearShootingStartLatitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSMinuteField.setName("gearShootingStartLatitudeDMSMinuteField");
        gearShootingStartLatitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLatitudeDMSMinuteField.setProperty("gearShootingStartLatitudeMinute");
        gearShootingStartLatitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLatitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLatitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitudeMinute"));
    }

    protected void createGearShootingStartLatitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLatitudeDMSSecondField", gearShootingStartLatitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLatitudeDMSSecondField.setName("gearShootingStartLatitudeDMSSecondField");
        gearShootingStartLatitudeDMSSecondField.setUseSign(false);
        gearShootingStartLatitudeDMSSecondField.setProperty("gearShootingStartLatitudeSecond");
        gearShootingStartLatitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLatitudeDMSSecondField.setShowReset(false);
        gearShootingStartLatitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLatitudeSecond"));
    }

    protected void createGearShootingStartLatitudeLayout() {
        $objectMap.put("gearShootingStartLatitudeLayout", gearShootingStartLatitudeLayout = new CardLayout2Ext(this, "gearShootingStartLatitudePanel"));
    }

    protected void createGearShootingStartLatitudePanel() {
        $objectMap.put("gearShootingStartLatitudePanel", gearShootingStartLatitudePanel = new JPanel());
        
        gearShootingStartLatitudePanel.setName("gearShootingStartLatitudePanel");
        gearShootingStartLatitudePanel.setLayout(gearShootingStartLatitudeLayout);
    }

    protected void createGearShootingStartLongitudeDDField() {
        $objectMap.put("gearShootingStartLongitudeDDField", gearShootingStartLongitudeDDField = new NumberEditor(this));
        
        gearShootingStartLongitudeDDField.setName("gearShootingStartLongitudeDDField");
        gearShootingStartLongitudeDDField.setUseSign(true);
        gearShootingStartLongitudeDDField.setProperty("gearShootingStartLongitude");
        gearShootingStartLongitudeDDField.setUseFloat(true);
        gearShootingStartLongitudeDDField.setShowReset(false);
        gearShootingStartLongitudeDDField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitude"));
    }

    protected void createGearShootingStartLongitudeDMDDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMDDegreeField", gearShootingStartLongitudeDMDDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDDegreeField.setName("gearShootingStartLongitudeDMDDegreeField");
        gearShootingStartLongitudeDMDDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMDDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMDDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMDDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMDDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitudeDegree"));
    }

    protected void createGearShootingStartLongitudeDMDMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMDMinuteField", gearShootingStartLongitudeDMDMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMDMinuteField.setName("gearShootingStartLongitudeDMDMinuteField");
        gearShootingStartLongitudeDMDMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMDMinuteField.setProperty("gearShootingStartLongitudeDecimalMinute");
        gearShootingStartLongitudeDMDMinuteField.setUseFloat(true);
        gearShootingStartLongitudeDMDMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMDMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitudeMinute"));
    }

    protected void createGearShootingStartLongitudeDMSDegreeField() {
        $objectMap.put("gearShootingStartLongitudeDMSDegreeField", gearShootingStartLongitudeDMSDegreeField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSDegreeField.setName("gearShootingStartLongitudeDMSDegreeField");
        gearShootingStartLongitudeDMSDegreeField.setUseSign(true);
        gearShootingStartLongitudeDMSDegreeField.setProperty("gearShootingStartLongitudeDegree");
        gearShootingStartLongitudeDMSDegreeField.setUseFloat(false);
        gearShootingStartLongitudeDMSDegreeField.setShowReset(false);
        gearShootingStartLongitudeDMSDegreeField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitudeDegree"));
    }

    protected void createGearShootingStartLongitudeDMSMinuteField() {
        $objectMap.put("gearShootingStartLongitudeDMSMinuteField", gearShootingStartLongitudeDMSMinuteField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSMinuteField.setName("gearShootingStartLongitudeDMSMinuteField");
        gearShootingStartLongitudeDMSMinuteField.setUseSign(false);
        gearShootingStartLongitudeDMSMinuteField.setProperty("gearShootingStartLongitudeMinute");
        gearShootingStartLongitudeDMSMinuteField.setUseFloat(false);
        gearShootingStartLongitudeDMSMinuteField.setShowReset(false);
        gearShootingStartLongitudeDMSMinuteField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitudeMinute"));
    }

    protected void createGearShootingStartLongitudeDMSSecondField() {
        $objectMap.put("gearShootingStartLongitudeDMSSecondField", gearShootingStartLongitudeDMSSecondField = new NumberEditor(this));
        
        gearShootingStartLongitudeDMSSecondField.setName("gearShootingStartLongitudeDMSSecondField");
        gearShootingStartLongitudeDMSSecondField.setUseSign(false);
        gearShootingStartLongitudeDMSSecondField.setProperty("gearShootingStartLongitudeSecond");
        gearShootingStartLongitudeDMSSecondField.setUseFloat(false);
        gearShootingStartLongitudeDMSSecondField.setShowReset(false);
        gearShootingStartLongitudeDMSSecondField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.gearShootingStartLongitudeSecond"));
    }

    protected void createGearShootingStartLongitudeLayout() {
        $objectMap.put("gearShootingStartLongitudeLayout", gearShootingStartLongitudeLayout = new CardLayout2Ext(this, "gearShootingStartLongitudePanel"));
    }

    protected void createGearShootingStartLongitudePanel() {
        $objectMap.put("gearShootingStartLongitudePanel", gearShootingStartLongitudePanel = new JPanel());
        
        gearShootingStartLongitudePanel.setName("gearShootingStartLongitudePanel");
        gearShootingStartLongitudePanel.setLayout(gearShootingStartLongitudeLayout);
    }

    protected void createGearShootingStartTimeField() {
        $objectMap.put("gearShootingStartTimeField", gearShootingStartTimeField = new SimpleTimeEditor(this));
        
        gearShootingStartTimeField.setName("gearShootingStartTimeField");
        gearShootingStartTimeField.setProperty("gearShootingStartTime");
    }

    protected void createGearShootingTabContent() {
        $objectMap.put("gearShootingTabContent", gearShootingTabContent = new GearShootingTabUI(this));
        
        gearShootingTabContent.setName("gearShootingTabContent");
    }

    protected void createGearTimeLabel() {
        $objectMap.put("gearTimeLabel", gearTimeLabel = new JLabel());
        
        gearTimeLabel.setName("gearTimeLabel");
        gearTimeLabel.setText(_("tutti.label.fishingOperation.gearTime"));
    }

    protected void createGeneralForm() {
        $objectMap.put("generalForm", generalForm = new Table());
        
        generalForm.setName("generalForm");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditFishingOperationUIHandler.class));
    }

    protected void createHydrologyTabContent() {
        $objectMap.put("hydrologyTabContent", hydrologyTabContent = new HydrologyTabUI(this));
        
        hydrologyTabContent.setName("hydrologyTabContent");
    }

    protected void createImportCasinoButton() {
        $objectMap.put("importCasinoButton", importCasinoButton = new JButton());
        
        importCasinoButton.setName("importCasinoButton");
        importCasinoButton.putClientProperty("tuttiAction", ImportCasinoAction.class);
    }

    protected void createLocationComboBox() {
        $objectMap.put("locationComboBox", locationComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        locationComboBox.setName("locationComboBox");
        locationComboBox.setI18nPrefix("tutti.property.");
        locationComboBox.setProperty("location");
        locationComboBox.setShowReset(true);
        locationComboBox.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.location"));
    }

    protected void createLocationLabel() {
        $objectMap.put("locationLabel", locationLabel = new JLabel());
        
        locationLabel.setName("locationLabel");
        locationLabel.setText(_("tutti.label.fishingOperation.location"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditFishingOperationUIModel.class));
    }

    protected void createMultirigAggregationField() {
        $objectMap.put("multirigAggregationField", multirigAggregationField = new JTextField());
        
        multirigAggregationField.setName("multirigAggregationField");
        multirigAggregationField.setColumns(15);
        multirigAggregationField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__multirigAggregationField"));
        multirigAggregationField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.multirigAggregation"));
    }

    protected void createMultirigAggregationLabel() {
        $objectMap.put("multirigAggregationLabel", multirigAggregationLabel = new JLabel());
        
        multirigAggregationLabel.setName("multirigAggregationLabel");
        multirigAggregationLabel.setText(_("tutti.label.fishingOperation.multirigAggregation"));
    }

    protected void createResetValidStateButton() {
        $objectMap.put("resetValidStateButton", resetValidStateButton = new JButton());
        
        resetValidStateButton.setName("resetValidStateButton");
        resetValidStateButton.setText(_("tutti.action.reset.fishingOperationValidState"));
        resetValidStateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetValidStateButton"));
    }

    protected void createSaisisseurList() {
        $objectMap.put("saisisseurList", saisisseurList = new BeanDoubleList<Person>());
        
        saisisseurList.setName("saisisseurList");
        saisisseurList.setI18nPrefix("tutti.property.");
        saisisseurList.setProperty("saisisseur");
        saisisseurList.setShowReset(true);
        saisisseurList.putClientProperty("validatorLabel", _("tutti.label.list.saisisseur"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.putClientProperty("tuttiAction", SaveFishingOperationAction.class);
    }

    protected void createStationNumberField() {
        $objectMap.put("stationNumberField", stationNumberField = new JTextField());
        
        stationNumberField.setName("stationNumberField");
        stationNumberField.setColumns(15);
        stationNumberField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__stationNumberField"));
        stationNumberField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.stationNumber"));
    }

    protected void createStationNumberLabel() {
        $objectMap.put("stationNumberLabel", stationNumberLabel = new JLabel());
        
        stationNumberLabel.setName("stationNumberLabel");
        stationNumberLabel.setText(_("tutti.label.fishingOperation.stationNumber"));
    }

    protected void createStrataComboBox() {
        $objectMap.put("strataComboBox", strataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        strataComboBox.setName("strataComboBox");
        strataComboBox.setI18nPrefix("tutti.property.");
        strataComboBox.setProperty("strata");
        strataComboBox.setShowReset(true);
        strataComboBox.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.strata"));
    }

    protected void createStrataLabel() {
        $objectMap.put("strataLabel", strataLabel = new JLabel());
        
        strataLabel.setName("strataLabel");
        strataLabel.setText(_("tutti.label.fishingOperation.strata"));
    }

    protected void createSubStrataComboBox() {
        $objectMap.put("subStrataComboBox", subStrataComboBox = new BeanComboBox<FishingOperationLocation>(this));
        
        subStrataComboBox.setName("subStrataComboBox");
        subStrataComboBox.setI18nPrefix("tutti.property.");
        subStrataComboBox.setProperty("subStrata");
        subStrataComboBox.setShowReset(true);
        subStrataComboBox.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.subStrata"));
    }

    protected void createSubStrataLabel() {
        $objectMap.put("subStrataLabel", subStrataLabel = new JLabel());
        
        subStrataLabel.setName("subStrataLabel");
        subStrataLabel.setText(_("tutti.label.fishingOperation.subStrata"));
    }

    protected void createTraitGearShootingTab() {
        $objectMap.put("traitGearShootingTab", traitGearShootingTab = new TabInfo());
    }

    protected void createTraitGeneralTab() {
        $objectMap.put("traitGeneralTab", traitGeneralTab = new TabInfo());
    }

    protected void createTraitHydrologyTabContent() {
        $objectMap.put("traitHydrologyTabContent", traitHydrologyTabContent = new TabInfo());
    }

    protected void createTraitVesselPanel() {
        $objectMap.put("traitVesselPanel", traitVesselPanel = new Table());
        
        traitVesselPanel.setName("traitVesselPanel");
    }

    protected void createTrawlDistanceField() {
        $objectMap.put("trawlDistanceField", trawlDistanceField = new NumberEditor(this));
        
        trawlDistanceField.setName("trawlDistanceField");
        trawlDistanceField.setProperty("trawlDistance");
        trawlDistanceField.setUseFloat(false);
        trawlDistanceField.setShowReset(true);
        trawlDistanceField.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.trawlDistance"));
    }

    protected void createTrawlDistanceLabel() {
        $objectMap.put("trawlDistanceLabel", trawlDistanceLabel = new JLabel());
        
        trawlDistanceLabel.setName("trawlDistanceLabel");
        trawlDistanceLabel.setText(_("tutti.label.fishingOperation.trawlDistance"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditFishingOperationUIModel.class, "validate"));
    }

    protected void createVesselComboBox() {
        $objectMap.put("vesselComboBox", vesselComboBox = new BeanComboBox<Vessel>(this));
        
        vesselComboBox.setName("vesselComboBox");
        vesselComboBox.setI18nPrefix("tutti.property.");
        vesselComboBox.setProperty("vessel");
        vesselComboBox.setShowReset(true);
        vesselComboBox.putClientProperty("validatorLabel", _("tutti.label.fishingOperation.vessel"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.label.fishingOperation.vessel"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToFishingOperationPane();
        addChildrenToFishingOperationTabPane();
        addChildrenToGeneralForm();
        // inline complete setup of $JPanel0
        $JPanel0.add(gearCaracteristicsTable, BorderLayout.CENTER);
        addChildrenToGearCaracteristicsTable();
        addChildrenToGearShootingStartLatitudePanel();
        // inline complete setup of $JPanel2
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSDegreeField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSMinuteField));
        $JPanel2.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMSSecondField));
        // inline complete setup of $JPanel3
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDDegreeField));
        $JPanel3.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLatitudeDMDMinuteField));
        addChildrenToGearShootingStartLongitudePanel();
        // inline complete setup of $JPanel4
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSDegreeField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSMinuteField));
        $JPanel4.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMSSecondField));
        // inline complete setup of $JPanel5
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDDegreeField));
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(gearShootingStartLongitudeDMDMinuteField));
        addChildrenToGearShootingEndLatitudePanel();
        // inline complete setup of $JPanel6
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSDegreeField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSMinuteField));
        $JPanel6.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMSSecondField));
        // inline complete setup of $JPanel7
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDDegreeField));
        $JPanel7.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLatitudeDMDMinuteField));
        addChildrenToGearShootingEndLongitudePanel();
        // inline complete setup of $JPanel8
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSDegreeField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSMinuteField));
        $JPanel8.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMSSecondField));
        // inline complete setup of $JPanel9
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDDegreeField));
        $JPanel9.add(SwingUtil.boxComponentWithJxLayer(gearShootingEndLongitudeDMDMinuteField));
        // inline complete setup of $JPanel10
        $JPanel10.add(trawlDistanceLabel, BorderLayout.WEST);
        $JPanel10.add(SwingUtil.boxComponentWithJxLayer(trawlDistanceField), BorderLayout.CENTER);
        // inline complete setup of $JPanel11
        $JPanel11.add(durationLabel, BorderLayout.WEST);
        $JPanel11.add(durationField, BorderLayout.CENTER);
        addChildrenToFishingOperationValidPanel();
        addChildrenToFishingOperationResetRadio();
        // inline complete setup of $HBox0
        $HBox0.add(fishingOperationValidRadio);
        $HBox0.add(fishingOperationInvalidRadio);
        addChildrenToFishingOperationValidRadio();
        addChildrenToFishingOperationInvalidRadio();
        // inline complete setup of $JPanel13
        $JPanel13.add(importCasinoButton);
        $JPanel13.add(attachmentsButton);
        // inline complete setup of $JPanel14
        $JPanel14.add(SwingUtil.boxComponentWithJxLayer(saisisseurList));
        $JPanel14.add(traitVesselPanel);
        addChildrenToTraitVesselPanel();
        addChildrenToCommentPane();
        // inline complete setup of $JPanel15
        $JPanel15.add(createFishingOperationActions, BorderLayout.CENTER);
        addChildrenToCreateFishingOperationActions();
        
        // apply 68 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 140 property setters
        strataComboBox.setBeanType(FishingOperationLocation.class);
        subStrataComboBox.setBeanType(FishingOperationLocation.class);
        locationComboBox.setBeanType(FishingOperationLocation.class);
        saisisseurList.setBeanType(Person.class);
        vesselComboBox.setBeanType(Vessel.class);
        gearComboBox.setBeanType(Gear.class);
        gearShootingStartLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingStartLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLongitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        gearShootingEndLatitudeLayout.setSelected( ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString() );
        stationNumberLabel.setLabelFor(stationNumberField);
        fishingOperationNumberLabel.setLabelFor(fishingOperationNumberField);
        fishingOperationNumberField.setBean(model);
        fishingOperationNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        fishingOperationNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        multirigAggregationLabel.setLabelFor(multirigAggregationField);
        strataLabel.setLabelFor(strataComboBox);
        strataComboBox.setBean(model);
        subStrataLabel.setLabelFor(subStrataComboBox);
        subStrataComboBox.setBean(model);
        locationLabel.setLabelFor(locationComboBox);
        locationComboBox.setBean(model);
        gearLatitudeLabel.setText(_("tutti.label.fishingOperation.gearLatitude", ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString()));
        gearLatitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearLongitudeLabel.setText(_("tutti.label.fishingOperation.gearLongitude", ((CoordinateEditorType)handler.getConfig().getCoordinateEditorType()).toString()));
        gearLongitudeLabel.setIcon(SwingUtil.createActionIcon("coordinates"));
        gearDateLabel.setIcon(SwingUtil.createActionIcon("calendar"));
        gearTimeLabel.setIcon(SwingUtil.createActionIcon("time"));
        gearShootingStartLatitudeDDField.setBean(model);
        gearShootingStartLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSDegreeField.setBean(model);
        gearShootingStartLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSMinuteField.setBean(model);
        gearShootingStartLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMSSecondField.setBean(model);
        gearShootingStartLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDDegreeField.setBean(model);
        gearShootingStartLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLatitudeDMDMinuteField.setBean(model);
        gearShootingStartLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDDField.setBean(model);
        gearShootingStartLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSDegreeField.setBean(model);
        gearShootingStartLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSMinuteField.setBean(model);
        gearShootingStartLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMSSecondField.setBean(model);
        gearShootingStartLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDDegreeField.setBean(model);
        gearShootingStartLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartLongitudeDMDMinuteField.setBean(model);
        gearShootingStartLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingStartLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingStartTimeField.setBean(model);
        gearShootingEndLatitudeDDField.setBean(model);
        gearShootingEndLatitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSDegreeField.setBean(model);
        gearShootingEndLatitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSMinuteField.setBean(model);
        gearShootingEndLatitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMSSecondField.setBean(model);
        gearShootingEndLatitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDDegreeField.setBean(model);
        gearShootingEndLatitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLatitudeDMDMinuteField.setBean(model);
        gearShootingEndLatitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLatitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDDField.setBean(model);
        gearShootingEndLongitudeDDField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDDField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSDegreeField.setBean(model);
        gearShootingEndLongitudeDMSDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSMinuteField.setBean(model);
        gearShootingEndLongitudeDMSMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMSSecondField.setBean(model);
        gearShootingEndLongitudeDMSSecondField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMSSecondField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDDegreeField.setBean(model);
        gearShootingEndLongitudeDMDDegreeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDDegreeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndLongitudeDMDMinuteField.setBean(model);
        gearShootingEndLongitudeDMDMinuteField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        gearShootingEndLongitudeDMDMinuteField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        gearShootingEndTimeField.setBean(model);
        trawlDistanceLabel.setLabelFor(trawlDistanceField);
        trawlDistanceField.setBean(model);
        trawlDistanceField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        trawlDistanceField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        durationLabel.setLabelFor(durationField);
        resetValidStateButton.setIcon(SwingUtil.createActionIcon("reset"));
        saisisseurList.setBean(model);
        saisisseurList.setBorder(BorderFactory.createTitledBorder(_("tutti.label.list.saisisseur")));
        traitVesselPanel.setBorder(BorderFactory.createTitledBorder(_("tutti.label.fishingOperation.other")));
        vesselLabel.setLabelFor(vesselComboBox);
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        vesselComboBox.setBean(model);
        gearLabel.setLabelFor(gearComboBox);
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        gearComboBox.setBean(model);
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.label.comment")));
        // late initializer
        attachmentEditor.pack();
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createGearShootingStartLongitudeLayout();
        createGearShootingStartLatitudeLayout();
        createGearShootingEndLongitudeLayout();
        createGearShootingEndLatitudeLayout();
        createFishingOperationPane();
        createFishingOperationTabPane();
        createGeneralForm();
        createStationNumberLabel();
        createStationNumberField();
        createFishingOperationNumberLabel();
        createFishingOperationNumberField();
        createMultirigAggregationLabel();
        createMultirigAggregationField();
        createStrataLabel();
        createStrataComboBox();
        createSubStrataLabel();
        createSubStrataComboBox();
        createLocationLabel();
        createLocationComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createGearCaracteristicsTable();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        createGearLatitudeLabel();
        createGearLongitudeLabel();
        createGearDateLabel();
        createGearTimeLabel();
        createGearShootingStartLabel();
        createGearShootingStartLatitudePanel();
        createGearShootingStartLatitudeDDField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMSDegreeField();
        createGearShootingStartLatitudeDMSMinuteField();
        createGearShootingStartLatitudeDMSSecondField();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createGearShootingStartLatitudeDMDDegreeField();
        createGearShootingStartLatitudeDMDMinuteField();
        createGearShootingStartLongitudePanel();
        createGearShootingStartLongitudeDDField();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMSDegreeField();
        createGearShootingStartLongitudeDMSMinuteField();
        createGearShootingStartLongitudeDMSSecondField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new GridLayout(1,0));
        createGearShootingStartLongitudeDMDDegreeField();
        createGearShootingStartLongitudeDMDMinuteField();
        createGearShootingStartDateField();
        createGearShootingStartTimeField();
        createGearShootingEndLabel();
        createGearShootingEndLatitudePanel();
        createGearShootingEndLatitudeDDField();
        // inline creation of $JPanel6
        $objectMap.put("$JPanel6", $JPanel6 = new JPanel());
        
        $JPanel6.setName("$JPanel6");
        $JPanel6.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMSDegreeField();
        createGearShootingEndLatitudeDMSMinuteField();
        createGearShootingEndLatitudeDMSSecondField();
        // inline creation of $JPanel7
        $objectMap.put("$JPanel7", $JPanel7 = new JPanel());
        
        $JPanel7.setName("$JPanel7");
        $JPanel7.setLayout(new GridLayout(1,0));
        createGearShootingEndLatitudeDMDDegreeField();
        createGearShootingEndLatitudeDMDMinuteField();
        createGearShootingEndLongitudePanel();
        createGearShootingEndLongitudeDDField();
        // inline creation of $JPanel8
        $objectMap.put("$JPanel8", $JPanel8 = new JPanel());
        
        $JPanel8.setName("$JPanel8");
        $JPanel8.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMSDegreeField();
        createGearShootingEndLongitudeDMSMinuteField();
        createGearShootingEndLongitudeDMSSecondField();
        // inline creation of $JPanel9
        $objectMap.put("$JPanel9", $JPanel9 = new JPanel());
        
        $JPanel9.setName("$JPanel9");
        $JPanel9.setLayout(new GridLayout(1,0));
        createGearShootingEndLongitudeDMDDegreeField();
        createGearShootingEndLongitudeDMDMinuteField();
        createGearShootingEndDateField();
        createGearShootingEndTimeField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        createFishingOperationRectiligneCheckBox();
        // inline creation of $JPanel10
        $objectMap.put("$JPanel10", $JPanel10 = new JPanel());
        
        $JPanel10.setName("$JPanel10");
        $JPanel10.setLayout(new BorderLayout());
        createTrawlDistanceLabel();
        createTrawlDistanceField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        // inline creation of $JPanel11
        $objectMap.put("$JPanel11", $JPanel11 = new JPanel());
        
        $JPanel11.setName("$JPanel11");
        $JPanel11.setLayout(new BorderLayout());
        createDurationLabel();
        createDurationField();
        createFishingOperationValidPanel();
        createResetValidStateButton();
        createFishingOperationResetRadio();
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        createFishingOperationValidRadio();
        createFishingOperationInvalidRadio();
        // inline creation of $JPanel12
        $objectMap.put("$JPanel12", $JPanel12 = new JPanel());
        
        $JPanel12.setName("$JPanel12");
        // inline creation of $JPanel13
        $objectMap.put("$JPanel13", $JPanel13 = new JPanel());
        
        $JPanel13.setName("$JPanel13");
        $JPanel13.setLayout(new GridLayout(1,0));
        createImportCasinoButton();
        createAttachmentsButton();
        // inline creation of $JPanel14
        $objectMap.put("$JPanel14", $JPanel14 = new JPanel());
        
        $JPanel14.setName("$JPanel14");
        $JPanel14.setLayout(new GridLayout(1,0));
        createSaisisseurList();
        createTraitVesselPanel();
        createVesselLabel();
        createVesselComboBox();
        createGearLabel();
        createGearComboBox();
        createCommentPane();
        createCommentField();
        createGearShootingTabContent();
        createEnvironmentTabContent();
        createHydrologyTabContent();
        // inline creation of $JPanel15
        $objectMap.put("$JPanel15", $JPanel15 = new JPanel());
        
        $JPanel15.setName("$JPanel15");
        $JPanel15.setLayout(new BorderLayout());
        createCreateFishingOperationActions();
        createCancelButton();
        createSaveButton();
        createAttachmentEditor();
        createTraitGeneralTab();
        createTraitGearShootingTab();
        createEnvironmentTab();
        createTraitHydrologyTabContent();
        createFishingOperationValid();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 68 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 68 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATION_NUMBER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("stationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(stationNumberField, model.getStationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("stationNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationNumberField.setModel(model.getFishingOperationNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationNumber", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_FISHING_OPERATION_NUMBER_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                fishingOperationNumberField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_AGGREGATION_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigAggregation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(multirigAggregationField, model.getMultirigAggregation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigAggregation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("strata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    strataComboBox.setSelectedItem(model.getStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("strata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUB_STRATA_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subStrata", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subStrataComboBox.setSelectedItem(model.getSubStrata());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subStrata", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("location", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    locationComboBox.setSelectedItem(model.getLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("location", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDDField.setModel(model.getGearShootingStartLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSMinuteField.setModel(model.getGearShootingStartLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMSSecondField.setModel(model.getGearShootingStartLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDDegreeField.setModel(model.getGearShootingStartLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLatitudeDMDMinuteField.setModel(model.getGearShootingStartLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLatitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDDField.setModel(model.getGearShootingStartLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSMinuteField.setModel(model.getGearShootingStartLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMSSecondField.setModel(model.getGearShootingStartLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDDegreeField.setModel(model.getGearShootingStartLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartLongitudeDMDMinuteField.setModel(model.getGearShootingStartLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_START_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingStartLongitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartDateField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_START_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingStartTimeField.setDate(model.getGearShootingStartDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDDField.setModel(model.getGearShootingEndLatitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSMinuteField.setModel(model.getGearShootingEndLatitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMSSecondField.setModel(model.getGearShootingEndLatitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDDegreeField.setModel(model.getGearShootingEndLatitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMDDegreeField.setNumberPattern(SIGNED_INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLatitudeDMDMinuteField.setModel(model.getGearShootingEndLatitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLatitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LATITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLatitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DDFIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDDField.setModel(model.getGearShootingEndLongitude());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitude", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSMinuteField.setModel(model.getGearShootingEndLongitudeMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSMINUTE_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSMinuteField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMSSecondField.setModel(model.getGearShootingEndLongitudeSecond());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeSecond", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMSSECOND_FIELD_NUMBER_PATTERN, true ,"INT_2_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMSSecondField.setNumberPattern(INT_2_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDDegreeField.setModel(model.getGearShootingEndLongitudeDegree());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDegree", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDDEGREE_FIELD_NUMBER_PATTERN, true ,"SIGNED_INT_3_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMDDegreeField.setNumberPattern(SIGNED_INT_3_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndLongitudeDMDMinuteField.setModel(model.getGearShootingEndLongitudeDecimalMinute());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndLongitudeDecimalMinute", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_GEAR_SHOOTING_END_LONGITUDE_DMDMINUTE_FIELD_NUMBER_PATTERN, true ,"DECIMAL2_3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                gearShootingEndLongitudeDMDMinuteField.setNumberPattern(DECIMAL2_3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndDateField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_SHOOTING_END_TIME_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearShootingEndTimeField.setDate(model.getGearShootingEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RECTILIGNE_CHECK_BOX_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationRectiligneCheckBox.setSelected(model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setEnabled(!model.isFishingOperationRectiligne());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationRectiligne", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setModel(model.getTrawlDistance());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TRAWL_DISTANCE_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                trawlDistanceField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRAWL_DISTANCE_FIELD_TOOL_TIP_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("trawlDistance", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    trawlDistanceField.setToolTipText(model.getTrawlDistance() != null ? _("tutti.tooltip.distanceInMilles", TuttiUIUtil.getDistanceInMilles(model.getTrawlDistance())) : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("trawlDistance", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DURATION_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("gearShootingEndDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(durationField, TuttiUIUtil.getDuration(model.getGearShootingStartDate(), model.getGearShootingEndDate()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingStartDate", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("gearShootingEndDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_RESET_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationResetRadio.setSelected(model.getFishingOperationValid() == null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_VALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationValidRadio.setSelected(model.getFishingOperationValid() == Boolean.TRUE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FISHING_OPERATION_INVALID_RADIO_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fishingOperationValid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fishingOperationInvalidRadio.setSelected(model.getFishingOperationValid() == Boolean.FALSE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fishingOperationValid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEnabled(model.getId() !=null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselComboBox.setSelectedItem(model.getVessel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GEAR_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gear", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    gearComboBox.setSelectedItem(model.getGear());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gear", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
    }

}