/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.MainUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationUpdater;

public class UpdateReferentialAction
extends AbstractMainUITuttiAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UpdateReferentialAction.class);

    public UpdateReferentialAction(MainUIHandler handler) {
        super(handler, "updateReferential", "update-referential", I18n._((String)"tutti.action.updateReferential", (Object[])new Object[0]), I18n._((String)"tutti.action.updateReferential.tip", (Object[])new Object[0]), true);
    }

    @Override
    protected void doAction(ActionEvent event) {
        TuttiApplicationConfig config = this.getContext().getConfig();
        File current = config.getDataDirectory();
        String url = config.getUpdateUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to update db (current data location: %s), using update url: %s", current, url));
        }
        ApplicationUpdater up = new ApplicationUpdater();
        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        this.getContext().getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage("Recherche de mises \u00e0 jour de base");
        TuttiApplicationUpdaterCallBack callback = new TuttiApplicationUpdaterCallBack(this.getContext(), progressionModel);
        callback.setTypes(TuttiApplicationUpdaterCallBack.UpdateType.DB);
        up.update(url, current, dest, false, (ApplicationUpdater.ApplicationUpdaterCallback)callback);
        if (callback.isDbUpdated()) {
            progressionModel.setMessage("Rechargement de la base de donn\u00e9es");
            this.getContext().setDbLoaded(true);
            this.getContext().reloadPersistenceService();
        } else {
            this.sendMessage("Aucune mise \u00e0 jour de base d\u00e9tect\u00e9e.");
        }
    }

    @Override
    protected void releaseAction(ActionEvent event) {
        this.getContext().getActionUI().getModel().setProgressionModel(null);
        super.releaseAction(event);
    }
}

