package fr.ifremer.tutti.ui.swing.content.db;

/*
 * #%L
 * Tutti :: UI
 * $Id: OpenDbAction.java 438 2013-02-18 07:40:56Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/db/OpenDbAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.MainUIHandler;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.event.ActionEvent;

import static org.nuiton.i18n.I18n._;

/**
 * To open existing db.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class OpenDbAction extends AbstractMainUITuttiAction {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(OpenDbAction.class);

    public OpenDbAction(MainUIHandler handler) {
        super(handler,
              "openDb",
              "open-db",
              _("tutti.action.openDb"),
              _("tutti.action.openDb.tip"),
              true);
    }

    @Override
    protected void doAction(ActionEvent event) {

        if (log.isDebugEnabled()) {
            log.debug("Will open db...");
        }
        getContext().setDbLoaded(true);
        getHandler().reloadPersistenceService();

        String jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();

        sendMessage(String.format("La base de données '%s' est ouverte.", jdbcUrl));

        if (log.isDebugEnabled()) {
            log.debug("Check db context");
        }
        getContext().checkDbContext();
        getContext().setScreen(TuttiScreen.SELECT_CRUISE);
    }
}