/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroup;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.elements.TableItem;

public class LayoutTableModel {
    private TableHandle table;

    public LayoutTableModel(TableHandle table) {
        this.table = table;
    }

    private LayoutTable getLayoutTable() {
        return ((TableItem)this.table.getElement()).getLayoutModel(this.table.getModule());
    }

    public LayoutSlot getLayoutSlotHeader() {
        return this.getLayoutTable().getHeader();
    }

    public LayoutSlot getLayoutSlotDetail() {
        return this.getLayoutTable().getDetail();
    }

    public LayoutSlot getLayoutSlotFooter() {
        return this.getLayoutTable().getFooter();
    }

    public TableHandle getTable() {
        return this.table;
    }

    public LayoutGroup getLayoutGroup(int groupLevel) {
        return this.getLayoutTable().getLayoutGroup(groupLevel);
    }

    public int getColumnCount() {
        return this.getLayoutTable().getColumnCount();
    }

    public int getRowCount() {
        return LayoutUtil.getRowCount(this.getLayoutTable());
    }

    public CellHandle getCell(int slotId, int rowId, int colId) {
        return this.getLayoutTable().getCell(slotId, rowId, colId);
    }

    public CellHandle getCell(int groupLevel, int slotId, int rowId, int colId) {
        return this.getLayoutTable().getCell(groupLevel, slotId, rowId, colId);
    }

    public CellHandle getCell(int rowPosn, int colPosn) {
        return this.getLayoutTable().getCell(rowPosn, colPosn);
    }
}

