package fr.ifremer.tutti.ichtyometer.tool;

/*
 * #%L
 * Tutti :: Ichtyometer API
 * $Id: CRCBuilderTool.java 1573 2014-02-04 16:41:40Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.4/tutti-ichtyometer/src/main/java/fr/ifremer/tutti/ichtyometer/tool/CRCBuilderTool.java $
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ichtyometer.feed.FeedReaderRecord;

import java.io.Console;
import java.io.PrintWriter;

/**
 * Created on 1/30/14.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 3.2
 */
public class CRCBuilderTool {

    public static void main(String[] args) {

        Console console = System.console();
        PrintWriter writer = console.writer();
        writer.println("CRCBuilderTool: to build CRC code v1.0");

        while (true) {

            writer.print("Enter new record (or q to quit): ");
            writer.flush();
            String command = console.readLine();

            if ("q".equals(command)) {
                break;
            }

            String crc = FeedReaderRecord.computeCRC(command);
            writer.println("CRC= " + crc);
        }
    }
}
