/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.BoatFilterImpl;
import fr.ifremer.suiviobsmer.bean.CompanyBoatInfos;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.BoatInfos;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.ElligibleBoat;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.WaoUser;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.AbstractFilteredPage;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.FeedBack;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import fr.ifremer.suiviobsmer.ui.data.BoatDataSource;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.pages.BoatActivityCalendar;
import fr.ifremer.suiviobsmer.ui.pages.Contacts;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/boats.css"})
public class Boats
extends AbstractFilteredPage
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private WaoUser user;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private PropertyAccess propertyAccess;
    @Property
    private String sampleRowContextId;
    @Property
    private Integer boatSelectedImmatriculation;
    @InjectComponent
    private FeedBack filterFeedback;
    @Property
    private UploadedFile boatsCsvFile;
    @Property
    private UploadedFile activityCalendarsCsvFile;
    private InputStream activityCalendarLogFile;
    protected static final String GZIP_MIMETYPE = "application/x-gzip";
    @Persist
    private BoatFilter boatFilter;
    @Persist
    private SampleRow sampleRow;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Persist
    private boolean filtersHidden;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private BoatDataSource boats;
    @Property
    private Boat boat;
    private boolean even = true;
    @InjectComponent
    private Zone boatsZone;
    @Persist
    private CompanyBoatInfos companyBoatInfos;
    @InjectComponent
    private Zone boatInfosZone;
    @Inject
    private Block displayBoatInfos;
    @Inject
    private Block editBoatInfos;
    @Property
    private ElligibleBoat elligibleBoat;
    @Property
    private String boatInfosSampleRowId;
    private boolean boatInfosEditable;
    private Date boardingFromDate;
    private GenericSelectModel<Company> companies;
    @Inject
    private ServiceUser serviceUser;
    @Property
    @Persist(value="flash")
    private String companySelectedId;
    private Company company;
    @InjectPage
    private Contacts contacts;
    @InjectPage
    private BoatActivityCalendar calendarPage;

    public boolean isOnlyForAdmin() {
        return false;
    }

    void setupRender() throws SuiviObsmerException {
        this.sampleRow = null;
        this.getSampleRow();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        if (this.isSampleRowExists()) {
            this.getFilter().setSampleRow(this.sampleRow);
            this.filtersHidden = false;
            this.boats = null;
            this.filterFeedback.addInfo("Vous \u00eates en cours de s\u00e9lection d'un navire pour la ligne du plan " + this.sampleRow.getCode());
            this.professionId = this.getSampleRow().getProfession().getTopiaId();
        }
        this.initSelectFilters(false, false, false);
        this.companyBoatInfos = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.sampleRowContextId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.boatSelectedImmatriculation = (Integer)ec.get(Integer.class, 1);
            }
        }
    }

    Object[] onPassivate() {
        return new Object[]{this.sampleRowContextId, this.boatSelectedImmatriculation};
    }

    @Log
    void onSuccessFromImportBoatsForm() {
        try {
            int[] result = this.serviceBoat.importBoatCsv(this.boatsCsvFile.getStream());
            this.boats = null;
            this.layout.getFeedBack().addInfo(result[0] + " navires import\u00e9s dont " + result[1] + " nouveaux");
        }
        catch (SuiviObsmerException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    InputStream getActivityCalendarLogFile() throws FileNotFoundException {
        if (this.activityCalendarLogFile == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getActivityCalendarLogFile]");
            }
            this.activityCalendarLogFile = this.serviceBoat.getActivityCalendarLogFile();
        }
        return this.activityCalendarLogFile;
    }

    public boolean isLogFileExists() {
        try {
            this.getActivityCalendarLogFile();
            return true;
        }
        catch (FileNotFoundException eee) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Aucun fichier de log existant pour les calendriers d'activit\u00e9");
            }
            return false;
        }
    }

    @Log
    void onSuccessFromImportActivityCalendarsForm() throws SuiviObsmerException, IOException {
        InputStream input = this.activityCalendarsCsvFile.getStream();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Content type : " + this.activityCalendarsCsvFile.getContentType());
        }
        if (this.activityCalendarsCsvFile.getContentType().equals(GZIP_MIMETYPE)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Gzip file");
            }
            input = new GZIPInputStream(input);
        }
        this.serviceBoat.importActivityCalendarCsv(input);
        this.companyBoatInfos = null;
    }

    public StreamResponse onActionFromShowActivityCalendarLogFile() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BoatFilter getFilter() throws SuiviObsmerException {
        if (this.boatFilter == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Create filter");
            }
            this.boatFilter = new BoatFilterImpl();
            this.boatFilter.setNbMonthFinishedFromToday(Integer.valueOf(-1));
        }
        return this.boatFilter;
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    public SampleRow getSampleRow() throws SuiviObsmerException {
        if (this.sampleRow == null && !StringUtils.isEmpty((String)this.sampleRowContextId)) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getSampleRow]");
            }
            this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowContextId);
        }
        return this.sampleRow;
    }

    public boolean isSampleRowExists() throws SuiviObsmerException {
        return this.getSampleRow() != null;
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws SuiviObsmerException {
        if (this.professionSelectModel == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getProfessions]");
            }
            List professions = this.serviceReferential.getProfessions();
            this.professionSelectModel = new GenericSelectModel(professions, Profession.class, "code", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public boolean isFiltersHidden() {
        return this.filtersHidden;
    }

    public String getHiddenStyle() {
        return this.isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        this.filtersHidden = false;
        return this.filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        this.filtersHidden = true;
        return this.filtersZone.getBody();
    }

    void onSelectedFromReset() {
        this.boatFilter = null;
        this.sampleRowContextId = null;
    }

    public void onSelectedFromSearch() throws SuiviObsmerException {
        super.onSelectedFromSearch();
        if (this.log.isDebugEnabled()) {
            this.log.debug("FILTER : facadeName=" + this.boatFilter.getFacadeName());
            this.log.debug("FILTER : sectorName=" + this.boatFilter.getSectorName());
            this.log.debug("FILTER : sampleRow=" + this.boatFilter.getSampleRow());
            this.log.debug("FILTER : profession=" + this.boatFilter.getProfession());
            this.log.debug("FILTER : boatName=" + this.boatFilter.getBoatName());
            this.log.debug("FILTER : boatImmatriculation=" + this.boatFilter.getBoatImmatriculation());
            this.log.debug("FILTER : boatDistrictCode=" + this.boatFilter.getBoatDistrictCode());
            this.log.debug("FILTER : company=" + this.boatFilter.getCompany());
        }
        Profession profession = (Profession)this.getProfessionSelectModel().findObject(this.professionId);
        this.boatFilter.setProfession(profession);
    }

    Object onSuccessFromFiltersForm() throws SuiviObsmerException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
        return this;
    }

    public BoatDataSource getBoats() throws SuiviObsmerException {
        if (this.boats == null) {
            this.boats = new BoatDataSource(this.getFilter(), this.serviceBoat);
        }
        return this.boats;
    }

    public String getRowStyle() {
        String result = "";
        boolean bl = this.even = !this.even;
        result = this.boatSelectedImmatriculation != null && this.boat.getImmatriculation() == this.boatSelectedImmatriculation.intValue() ? "selected" : (!this.boat.getActive() ? "refused" : (this.even ? "even" : "odd"));
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean canCreateNewContactFromList() throws SuiviObsmerException {
        if (!this.user.getAdmin() && this.isSampleRowExists()) {
            return this.boat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) throws SuiviObsmerException {
        this.boatSelectedImmatriculation = boatImma;
        this.companyBoatInfos = null;
        if (this.user.getAdmin() && this.getCompany() != null) {
            this.companySelectedId = this.getCompany().getTopiaId();
        }
        return this.boatsZone.getBody();
    }

    public boolean isActivityCalendarImportRun() {
        return SuiviObsmerContext.isActivityCalendarImportRun();
    }

    public Block getActiveBoatInfosBlock() {
        if (this.boatInfosEditable) {
            return this.editBoatInfos;
        }
        return this.displayBoatInfos;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws SuiviObsmerException {
        if (this.companyBoatInfos == null && this.boatSelectedImmatriculation != null && this.getCompany() != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("BUSINESS REQUEST [getElligibleBoats]");
            }
            this.companyBoatInfos = this.serviceBoat.getCompanyBoatInfos(this.boatSelectedImmatriculation.intValue(), this.getCompany());
        }
        return this.companyBoatInfos;
    }

    public GenericSelectModel<Company> getCompanies() throws SuiviObsmerException {
        if (this.companies == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("BUSINESS REQUEST [getCompanies]");
            }
            List results = this.serviceUser.getCompanies(true);
            this.companies = new GenericSelectModel(results, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companies;
    }

    public Company getCompany() throws SuiviObsmerException {
        if (this.company == null) {
            if (StringUtils.isNotEmpty((String)this.companySelectedId)) {
                this.company = (Company)this.getCompanies().findObject(this.companySelectedId);
            } else if (!this.user.getAdmin()) {
                this.company = this.user.getCompany();
            }
        }
        return this.company;
    }

    public Boat getBoatSelected() throws SuiviObsmerException {
        return (Boat)this.getBoats().get((Object)this.boatSelectedImmatriculation);
    }

    public Date getBoardingFromDate() {
        if (this.boardingFromDate == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(2, -12);
            this.boardingFromDate = calendar.getTime();
        }
        return this.boardingFromDate;
    }

    public void setBoardingFromDate(Date boardingFromDate) {
        this.boardingFromDate = boardingFromDate;
    }

    public BoatInfos getBoatInfos() throws SuiviObsmerException {
        if (this.getCompanyBoatInfos() == null) {
            return null;
        }
        return this.getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactStyle() throws SuiviObsmerException {
        Contact contact = this.getCompanyBoatInfos().getLastContact();
        return BusinessUtils.getContactStyle((Contact)contact, (boolean)this.user.getAdmin());
    }

    public String getElligibleRowInfos() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse((Boolean)this.elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws SuiviObsmerException {
        if (!this.user.getAdmin() && !this.isElligibleBoatCompanyActiveFalse()) {
            Boat currentBoat = this.getBoatInfos().getBoat();
            return currentBoat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    public String getElligibleRowStyle() {
        boolean condition1 = this.elligibleBoat.getCompanyActive() == null && !this.elligibleBoat.getGlobalActive();
        return condition1 || this.isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    Block onSuccessFromCompanySelectForm() throws SuiviObsmerException {
        this.companyBoatInfos = null;
        this.getCompanyBoatInfos();
        return this.boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() throws SuiviObsmerException {
        this.boatInfosEditable = true;
        this.getFilter().setNbMonthFinishedFromToday(null);
        this.resetSampleRowSelect();
        this.getFilter().setNbMonthFinishedFromToday(Integer.valueOf(-1));
        return this.boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws SuiviObsmerException {
        this.companyBoatInfos = null;
        return this.boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws SuiviObsmerException {
        this.boatInfosEditable = true;
        if (StringUtils.isNotEmpty((String)this.boatInfosSampleRowId)) {
            SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.boatInfosSampleRowId);
            this.companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws SuiviObsmerException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws SuiviObsmerException {
        if (!this.boatInfosEditable) {
            this.serviceBoat.createUpdateCompanyBoatInfos(this.companyBoatInfos);
        }
        return this.boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws SuiviObsmerException {
        return this.boatInfosZone.getBody();
    }

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws SuiviObsmerException {
        this.sampleRow = this.getSampleRow();
        this.boat = (Boat)this.getBoats().get((Object)boatImmatriculation);
        this.contacts.createNewContact(this.boat, this.sampleRow);
        return this.contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws SuiviObsmerException {
        ElligibleBoat elligible = this.getCompanyBoatInfos().getElligibleBoat(sampleRowCode);
        this.sampleRow = elligible.getSampleRow();
        this.contacts.createNewContact(this.getBoatSelected(), this.sampleRow);
        return this.contacts;
    }

    public boolean hasActivityCalendar() throws SuiviObsmerException {
        return this.getBoatSelected().sizeActivityCalendar() != 0;
    }

    Object onActionFromShowLastActivityCalendar() throws SuiviObsmerException {
        this.calendarPage.setBoat(this.getBoatSelected());
        return this.calendarPage;
    }
}

