/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.text;

import fr.ifremer.isisfish.ui.widget.text.SyntaxEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;

public class SyntaxEditor
extends SyntaxEditorUI
implements DocumentListener {
    private static final long serialVersionUID = 8010988112139944408L;
    private static Log log = LogFactory.getLog(SyntaxEditor.class);
    protected boolean askIfNotSaved = false;
    protected File file;
    protected transient boolean modified;
    protected transient long lastSaveTimestamp;
    protected Action saveAction;
    protected WatchService watchService;
    protected Thread watchThread;
    protected JPanel askReloadPanel;

    public SyntaxEditor() {
        int c = this.getToolkit().getMenuShortcutKeyMask();
        this.saveAction = new AbstractAction(I18n.t((String)"isisfish.editor.save", (Object[])new Object[0]), new ImageIcon(this.getClass().getResource("/icons/script/disk-black.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxEditor.this.save();
            }
        };
        this.saveAction.setEnabled(false);
        this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, c));
        this.setAutocomplete();
        this.textArea.getDocument().addDocumentListener(this);
    }

    protected void setAutocomplete() {
    }

    protected void finalize() throws Throwable {
        try {
            this.watchService.close();
        }
        finally {
            super.finalize();
        }
    }

    public boolean isAskIfNotSaved() {
        return this.askIfNotSaved;
    }

    public void setAskIfNotSaved(boolean askIfNotSaved) {
        this.askIfNotSaved = askIfNotSaved;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
        this.saveAction.setEnabled(modified);
    }

    public boolean isModified() {
        return this.modified;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textArea.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textArea.getDocument().removeDocumentListener(listener);
    }

    public boolean open(File file) {
        boolean result;
        block22: {
            result = this.askAndSaveOrCancel();
            if (result) {
                this.clearReloadPanel();
                try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                    String ext = FileUtil.extension((File)file, (String[])new String[0]);
                    if ("java".equalsIgnoreCase(ext)) {
                        this.textArea.setSyntaxEditingStyle("text/java");
                    } else if ("xml".equalsIgnoreCase(ext)) {
                        this.textArea.setSyntaxEditingStyle("text/xml");
                    } else if ("sql".equalsIgnoreCase(ext)) {
                        this.textArea.setSyntaxEditingStyle("text/sql");
                    } else if ("r".equalsIgnoreCase(ext)) {
                        this.textArea.setSyntaxEditingStyle("text/perl");
                    }
                    this.textArea.read((Reader)in, null);
                    this.textArea.setCaretPosition(0);
                    this.setFile(file);
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block22;
                    log.warn((Object)"Can't read file", (Throwable)eee);
                }
            }
        }
        return result;
    }

    protected boolean askAndSaveOrCancel() {
        boolean result = true;
        if (this.isAskIfNotSaved() && this.isModified()) {
            int val = JOptionPane.showConfirmDialog((Component)((Object)this), I18n.t((String)"isisfish.editor.saveorcancel.message", (Object[])new Object[]{this.file.getName()}), I18n.t((String)"isisfish.editor.saveorcancel.title", (Object[])new Object[0]), 1, 3);
            switch (val) {
                case 0: {
                    this.save();
                    result = true;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public boolean close() {
        boolean result = this.askAndSaveOrCancel();
        this.setFile(null);
        return result;
    }

    protected void setFile(File file) {
        this.file = file;
        this.setEnabled(file != null);
        this.setModified(false);
        if (file != null) {
            this.detectExternalChanges(file);
        }
    }

    public void save() {
        block14: {
            this.clearReloadPanel();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);){
                this.lastSaveTimestamp = System.currentTimeMillis();
                this.textArea.write((Writer)out);
                this.setModified(false);
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block14;
                log.warn((Object)"Can't save file", (Throwable)eee);
            }
        }
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void copy() {
        this.textArea.copy();
    }

    public void paste() {
        this.textArea.paste();
    }

    public void cut() {
        this.textArea.cut();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    public Action getSaveAction() {
        return this.saveAction;
    }

    protected void clearReloadPanel() {
        if (this.askReloadPanel != null) {
            this.hideBottomComponent();
            this.askReloadPanel = null;
        }
    }

    protected void detectExternalChanges(File file) {
        block5: {
            if (this.askIfNotSaved) {
                try {
                    if (this.watchService == null) {
                        this.watchService = FileSystems.getDefault().newWatchService();
                    }
                    if (this.watchThread == null) {
                        this.watchThread = new WatchThread();
                        this.watchThread.start();
                    }
                    Path filePath = file.toPath();
                    Path parentPath = filePath.getParent();
                    parentPath.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Can't listen for file", (Throwable)ex);
                }
            }
        }
    }

    protected void notifyFileChanged(final File file) {
        if (this.askReloadPanel == null && file.equals(this.file)) {
            if (file.lastModified() - this.lastSaveTimestamp < 1000L) {
                return;
            }
            this.setModified(true);
            this.askReloadPanel = new JPanel(new BorderLayout());
            this.askReloadPanel.setBackground(new Color(242, 242, 189));
            this.askReloadPanel.add((Component)new JLabel(I18n.t((String)"isisfish.editor.reloadExternal", (Object[])new Object[0]), new ImageIcon(this.getClass().getResource("/icons/common/exclamation.png")), 2), "Center");
            JPanel actionsPanel = new JPanel(new FlowLayout());
            actionsPanel.setBackground(new Color(242, 242, 189));
            actionsPanel.add(new JButton(new AbstractAction(I18n.t((String)"isisfish.editor.reload", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntaxEditor.this.setModified(false);
                    SyntaxEditor.this.open(file);
                }
            }));
            actionsPanel.add(new JButton(new AbstractAction(I18n.t((String)"isisfish.editor.cancel", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SyntaxEditor.this.clearReloadPanel();
                }
            }));
            this.askReloadPanel.add((Component)actionsPanel, "East");
            this.addBottomComponent(this.askReloadPanel);
            this.showBottomComponent(this.askReloadPanel);
        }
    }

    class WatchThread
    extends Thread {
        WatchThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    WatchKey wk = SyntaxEditor.this.watchService.take();
                    for (WatchEvent<?> event : wk.pollEvents()) {
                        Path changed = (Path)event.context();
                        Path watchPath = (Path)wk.watchable();
                        File fullFile = new File(watchPath.toFile(), changed.toString());
                        SyntaxEditor.this.notifyFileChanged(fullFile);
                    }
                    boolean valid = wk.reset();
                    if (valid || !log.isErrorEnabled()) continue;
                    log.error((Object)"Watch service unregistered");
                }
            }
            catch (InterruptedException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Thread interrupted", (Throwable)ex);
                }
                return;
            }
        }
    }
}

