/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.optimization;

import fr.ifremer.isisfish.entities.Observation;
import fr.ifremer.isisfish.export.Export;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.nuiton.i18n.I18n;

public class ExportObservationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7555677813473489539L;
    protected Map<Export, Observation> optimizationExportsObservations;
    protected List<Export> keysCache;
    public static final String[] COLUMN_NAMES = new String[]{I18n.t((String)"isisfish.optimization.export", (Object[])new Object[0]), I18n.t((String)"isisfish.optimization.observation", (Object[])new Object[0])};

    public ExportObservationTableModel() {
    }

    public ExportObservationTableModel(Map<Export, Observation> optimizationExportsObservations) {
        this();
        this.setOptimizationExportsObservations(optimizationExportsObservations);
    }

    public void setOptimizationExportsObservations(Map<Export, Observation> optimizationExportsObservations) {
        this.optimizationExportsObservations = optimizationExportsObservations;
        this.keysCache = new ArrayList<Export>(optimizationExportsObservations.keySet());
        this.fireTableDataChanged();
    }

    public Export getExportForRow(int line) {
        return this.keysCache.get(line);
    }

    public void deleteExport(Export export) {
        int index = this.keysCache.indexOf(export);
        this.keysCache.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public int getColumnCount() {
        int result = 2;
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.keysCache != null) {
            result = this.keysCache.size();
        }
        return result;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Export export = this.keysCache.get(rowIndex);
        Object result = export;
        if (columnIndex == 1) {
            result = this.optimizationExportsObservations.get(export);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Export export = this.getExportForRow(rowIndex);
        this.optimizationExportsObservations.put(export, (Observation)aValue);
    }
}

