/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import fr.ifremer.isisfish.logging.LogLevel;
import java.util.ArrayList;

public class LogLevelUtil {
    public static boolean contains(int ordinal, int levels) {
        return (levels >> ordinal) % 2 == 1;
    }

    public static LogLevel[] getLogLevels(int levels) {
        ArrayList<LogLevel> result = new ArrayList<LogLevel>();
        for (LogLevel logLevel : LogLevel.values()) {
            if (!LogLevelUtil.contains(logLevel.ordinal(), levels)) continue;
            result.add(logLevel);
        }
        return result.toArray(new LogLevel[result.size()]);
    }

    public static int createSet(int firstOrdinal, int ... ordinals) {
        ArrayList<LogLevel> levelsUsed = new ArrayList<LogLevel>();
        int result = 0;
        LogLevel levelFound = LogLevel.getLogLevel(firstOrdinal);
        if (levelFound != null) {
            levelsUsed.add(levelFound);
        }
        for (int ordinal : ordinals) {
            levelFound = LogLevel.getLogLevel(ordinal);
            if (levelFound == null || levelsUsed.contains((Object)levelFound)) continue;
            levelsUsed.add(levelFound);
        }
        for (LogLevel logLevel : levelsUsed) {
            result += logLevel.mask();
        }
        return result;
    }

    public static int createSet(LogLevel firstLevel, LogLevel ... levels) {
        int[] evels = new int[levels.length];
        if (levels.length > 0) {
            for (int i = 0; i < levels.length; ++i) {
                evels[i] = levels[i].ordinal();
            }
        }
        return LogLevelUtil.createSet(firstLevel.ordinal(), evels);
    }

    public static int addToSet(int ordinal, int setOflevels) {
        int result = setOflevels;
        if (!LogLevelUtil.contains(ordinal, setOflevels)) {
            result = setOflevels + LogLevel.getLogLevel(ordinal).mask();
        }
        return result;
    }

    public static int removeFromSet(int ordinal, int setOfLevels) {
        int result = setOfLevels;
        if (LogLevelUtil.contains(ordinal, setOfLevels)) {
            result = setOfLevels - LogLevel.getLogLevel(ordinal).mask();
        }
        return result;
    }
}

