/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.PopulationGroupAbstract;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.types.Month;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class PopulationGroupImpl
extends PopulationGroupAbstract {
    private static final Log log = LogFactory.getLog(PopulationGroupImpl.class);
    private static final long serialVersionUID = 1L;

    @Override
    public double getAge() {
        double result = 0.0;
        if (this.getPopulation() != null && this.getPopulation().getSpecies() != null) {
            result = this.getPopulation().getSpecies().getAgeGroupType() ? super.getAge() : this.getPopulation().getAge(this.getLength(), this) / (double)Month.NUMBER_OF_MONTH;
        }
        return result;
    }

    @Override
    public double getLength() {
        double result = 0.0;
        if (this.getPopulation() != null && this.getPopulation().getSpecies() != null) {
            result = !this.getPopulation().getSpecies().getAgeGroupType() ? (this.getMinLength() + this.getMaxLength()) / 2.0 : this.getPopulation().getLength(this.getAge() * (double)Month.NUMBER_OF_MONTH, this);
        }
        return result;
    }

    @Override
    public boolean isInLength(double length) {
        boolean result = this.getMinLength() <= length && length <= this.getMaxLength();
        return result;
    }

    @Override
    public double getMeanWeight() {
        double result;
        block3: {
            result = 0.0;
            try {
                Equation eq = this.getPopulation().getMeanWeight();
                result = eq.evaluate("group", this);
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in mean weight equation");
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public double getNaturalDeathRate(Zone zone) {
        double result;
        block4: {
            result = 0.0;
            try {
                Equation eq = this.getPopulation().getNaturalDeathRate();
                if (eq != null) {
                    result = eq.evaluate("pop", this.getPopulation(), "group", this, "zone", zone);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in natural death rate equation");
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public double getPrice() {
        double result;
        block4: {
            result = 0.0;
            try {
                Equation eq = this.getPopulation().getPrice();
                if (eq != null) {
                    result = eq.evaluate("group", this);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in price equation");
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public double getMaturityOgive() {
        double result;
        block4: {
            result = 0.0;
            try {
                Equation eq = this.getPopulation().getMaturityOgiveEquation();
                if (eq != null) {
                    result = eq.evaluate("group", this);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in maturityOgive equation");
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public double getReproductionRate() {
        double result;
        block4: {
            result = 0.0;
            try {
                Equation eq = this.getPopulation().getReproductionRateEquation();
                if (eq != null) {
                    result = eq.evaluate("group", this);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in reproductionRate equation");
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return I18n.t((String)"isisfish.populationGroup.toString", (Object[])new Object[]{this.getPopulation(), this.getId()});
    }
}

