/*
 * #%L
 * IsisFish
 * 
 * $Id: Nocache.java 3798 2012-10-30 10:39:32Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/util/Nocache.java $
 * %%
 * Copyright (C) 2012 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation pour specifier à l'aspect du cache que l'on ne souhaite ne pas
 * mettre en cache l'appel d'une méthode ou des méthodes d'une classe.
 *
 * @author echatellier
 * @version $Revision: 3798 $
 *
 * Last update: $Date: 2012-10-30 11:39:32 +0100 (mar. 30 oct. 2012) $
 * by : $Author: echatellier $
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface Nocache {

}
