/*
 * Decompiled with CFR 0.152.
 */
package rules;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.rule.AbstractRule;
import fr.ifremer.isisfish.simulator.MetierMonitor;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.Doc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import scripts.ResultName;

public class InterdictionEnginPreSimu
extends AbstractRule {
    private static Log log = LogFactory.getLog(InterdictionEnginPreSimu.class);
    @Doc(value="do the doc of param gear")
    public Gear param_gear = null;
    @Doc(value="do the doc of param beginMonth")
    public Month param_beginMonth = Month.JANUARY;
    @Doc(value="do the doc of param endMonth")
    public Month param_endMonth = Month.DECEMBER;
    protected Map<Month, MatrixND> tableNonActivite = new HashMap<Month, MatrixND>();
    protected boolean affectNonActivite = false;
    protected String[] necessaryResult = new String[0];

    public String[] getNecessaryResult() {
        return this.necessaryResult;
    }

    public String getDescription() throws Exception {
        return "Prohibited gear";
    }

    public void init(SimulationContext context) throws Exception {
        MetierMonitor metierMon = context.getMetierMonitor();
        Gear EnginInterdit = this.param_gear;
        log.info((Object)("nom de l'engin interdit " + EnginInterdit.getName()));
        FisheryRegion RegionSimu = RegionStorage.getFisheryRegion((TopiaContext)context.getDB());
        List ListeMetiers = RegionSimu.getMetier();
        for (Metier metier : ListeMetiers) {
            if (!metier.getGear().equals(EnginInterdit)) continue;
            List ListeStrat = RegionSimu.getStrategy();
            for (Strategy Strat : ListeStrat) {
                SetOfVessels vessels = Strat.getSetOfVessels();
                if (vessels.getPossibleMetiers(metier) == null) continue;
                for (Month mois : Month.getMonths((Month)this.param_beginMonth, (Month)this.param_endMonth)) {
                    StrategyMonthInfo StratMonthInfo = Strat.getStrategyMonthInfo(mois);
                    metierMon.addforbiddenMetier(metier, mois);
                    ArrayList MetiersPossibles = new ArrayList(Strat.getSetOfVessels().getPossibleMetiers());
                    Iterator effort = MetiersPossibles.iterator();
                    while (effort.hasNext()) {
                        Metier met = ((EffortDescription)effort.next()).getPossibleMetiers();
                        if (StratMonthInfo.getProportionMetier(met) != 0.0 && !met.getGear().equals(metier.getGear()) && !met.getName().equalsIgnoreCase("nonActivite") && !metierMon.isForbidden(metier, mois)) continue;
                        effort.remove();
                    }
                    if (MetiersPossibles.size() != 0) {
                        int NbMetier = MetiersPossibles.size();
                        for (EffortDescription effort2 : MetiersPossibles) {
                            Metier met = effort2.getPossibleMetiers();
                            double NouvelleProportion = StratMonthInfo.getProportionMetier(met) + StratMonthInfo.getProportionMetier(metier) / (double)NbMetier;
                            StratMonthInfo.setProportionMetier(met, NouvelleProportion);
                        }
                        StratMonthInfo.setProportionMetier(metier, 0.0);
                        continue;
                    }
                    log.info((Object)"debut reportNonActivite");
                    MatrixND matNonActiviteMois = this.tableNonActivite.get(mois);
                    if (matNonActiviteMois == null) {
                        matNonActiviteMois = MatrixFactory.getInstance().create(ResultName.MATRIX_NO_ACTIVITY, new List[]{ListeStrat, ListeMetiers}, new String[]{"Strategies", "Metiers"});
                        this.tableNonActivite.put(mois, matNonActiviteMois);
                    }
                    matNonActiviteMois.setValue((Object)Strat, (Object)metier, StratMonthInfo.getProportionMetier(metier));
                    log.info((Object)"fin reportNonActivite");
                    StratMonthInfo.setProportionMetier(metier, 0.0);
                }
            }
        }
    }

    public boolean condition(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        boolean result = false;
        MatrixND mat = this.tableNonActivite.get(step.getMonth());
        if (mat != null && !this.affectNonActivite) {
            result = true;
        }
        return result;
    }

    public void preAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectNonActivite = true;
        MatrixND mat = this.tableNonActivite.get(step.getMonth());
        MetierMonitor metierMon = context.getMetierMonitor();
        MatrixND noActivity = metierMon.getNoActivity(step);
        if (noActivity == null) {
            metierMon.setNoActivity(step, mat.copy());
        } else {
            noActivity.add(mat);
        }
    }

    public void postAction(SimulationContext context, TimeStep step, Metier metier) throws Exception {
        this.affectNonActivite = false;
    }
}

