/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.com;

import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class GraphDownloadAction
extends CoserAction {
    private static final long serialVersionUID = 3385467755357775199L;
    private static final Log log = LogFactory.getLog(GraphDownloadAction.class);
    protected String zone;
    protected String indicator;
    protected String list;

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    public String getList() {
        return this.list;
    }

    public void setList(String list) {
        this.list = list;
    }

    @Action(results={@Result(type="stream", params={"contentType", "application/zip", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() {
        return "success";
    }

    public String getFilename() {
        return this.indicator + ".zip";
    }

    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();
        Locale locale = this.getLocale();
        String localeCode = locale.getLanguage();
        FileInputStream input = null;
        try {
            File mapImage = webService.getChartData(this.zone, null, this.indicator, this.list, localeCode);
            input = new FileInputStream(mapImage);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get file data", (Throwable)ex);
            }
            throw new CoserWebException("Can't get map file", (Throwable)ex);
        }
        return input;
    }
}

