/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.common;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.util.Map;

public abstract class CommonZone
extends CoserAction {
    private static final long serialVersionUID = 3385467755357775199L;
    protected String facade;
    protected Map<String, String> zones;
    protected Map<String, String> zonesPictures;
    protected Map<String, String> zonesMetaInfo;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public Map<String, String> getZones() {
        return this.zones;
    }

    public Map<String, String> getZonesPictures() {
        return this.zonesPictures;
    }

    public Map<String, String> getZonesMetaInfo() {
        return this.zonesMetaInfo;
    }

    public String getFacadeDisplayName() {
        WebService webService = ServiceFactory.getWebService();
        String displayName = null;
        try {
            displayName = (String)webService.getFacades().get(this.facade);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get species display name", (Throwable)ex);
        }
        return displayName;
    }

    public String execute() {
        WebService webService = ServiceFactory.getWebService();
        try {
            this.zones = webService.getZoneForFacade(this.facade, false, false);
            this.zonesPictures = webService.getZonePictures();
            this.zonesMetaInfo = webService.getZoneMetaInfo();
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get zone map", (Throwable)ex);
        }
        return "success";
    }
}

