/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.com;

import fr.ifremer.coser.CoserBusinessException;
import fr.ifremer.coser.services.WebService;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.ServiceFactory;
import fr.ifremer.coser.web.actions.common.CoserAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class GraphDataAction
extends CoserAction {
    private static final long serialVersionUID = 3385467755357775199L;
    protected String zone;
    protected String indicator;

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public void setIndicator(String indicator) {
        this.indicator = indicator;
    }

    @Action(results={@Result(type="stream", params={"contentType", "image/png", "inputName", "inputStream"})})
    public String execute() {
        return "success";
    }

    public InputStream getInputStream() {
        WebService webService = ServiceFactory.getWebService();
        Locale locale = this.getLocale();
        String localeCode = locale.getLanguage();
        FileInputStream input = null;
        try {
            File mapImage = webService.getChart(this.zone, null, this.indicator, localeCode);
            input = new FileInputStream(mapImage);
        }
        catch (CoserBusinessException ex) {
            throw new CoserWebException("Can't get map file", (Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            throw new CoserWebException("Can't get map file", (Throwable)ex);
        }
        return input;
    }
}

