/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.coselmar.config.CoselmarServicesConfigOption;
import fr.ifremer.coselmar.exceptions.CoselmarTechnicalException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

public class CoselmarServicesConfig {
    private static final Log log = LogFactory.getLog(CoselmarServicesConfig.class);
    protected ApplicationConfig applicationConfig = new ApplicationConfig();

    public CoselmarServicesConfig(String filename) {
        this(filename, null);
    }

    public CoselmarServicesConfig(String filename, Properties defaultValues) {
        this.applicationConfig.loadDefaultOptions((ConfigOptionDef[])CoselmarServicesConfigOption.values());
        this.applicationConfig.setAppName("coselmar");
        this.applicationConfig.setConfigFileName(filename);
        if (defaultValues != null) {
            for (Map.Entry<Object, Object> entry : defaultValues.entrySet()) {
                this.applicationConfig.setOption((String)entry.getKey(), (String)entry.getValue());
            }
        }
        try {
            this.applicationConfig.parse(new String[0]);
        }
        catch (ArgumentsParserException e) {
            throw new CoselmarTechnicalException(e);
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Coselmar configuration:");
            builder.append("\nFilename: ").append(filename);
            ArrayList options = Lists.newArrayList((Object[])CoselmarServicesConfigOption.values());
            for (CoselmarServicesConfigOption option : options) {
                builder.append(String.format("\n%1$-40s = %2$s", option.getKey(), this.applicationConfig.getOption((ConfigOptionDef)option)));
            }
            log.info((Object)builder.toString());
        }
    }

    public Map<String, String> getTopiaProperties() {
        HashMap topiaParameters = Maps.newHashMap();
        Properties properties = this.applicationConfig.getOptionStartsWith("hibernate");
        properties.putAll((Map<?, ?>)this.applicationConfig.getOptionStartsWith("topia"));
        for (Object o : properties.keySet()) {
            String key = String.valueOf(o);
            String value = (String)this.applicationConfig.getOption(String.class, key);
            topiaParameters.put(key, value);
        }
        return topiaParameters;
    }

    public File getDataDirectory() {
        return this.applicationConfig.getOptionAsFile(CoselmarServicesConfigOption.DATA_DIRECTORY.key);
    }

    public File getIndexDirectory() {
        File indexFile = this.applicationConfig.getOptionAsFile(CoselmarServicesConfigOption.INDEX_DIRECTORY.key);
        if (indexFile == null) {
            indexFile = this.applicationConfig.getOptionAsFile(CoselmarServicesConfigOption.DATA_DIRECTORY.key);
        }
        return indexFile;
    }

    public String getSmtpHost() {
        return this.applicationConfig.getOption(CoselmarServicesConfigOption.SMTP_HOST.key);
    }

    public int getSmtpPort() {
        return this.applicationConfig.getOptionAsInt(CoselmarServicesConfigOption.SMTP_PORT.key);
    }

    public String getSmtpFrom() {
        return this.applicationConfig.getOption(CoselmarServicesConfigOption.SMTP_FROM.key);
    }

    public boolean isLogConfigurationProvided() {
        boolean logConfigurationProvided = StringUtils.isNotBlank((CharSequence)this.applicationConfig.getOption(CoselmarServicesConfigOption.LOG_CONFIGURATION_FILE.key));
        return logConfigurationProvided;
    }

    public File getLogConfigurationFile() {
        return this.applicationConfig.getOptionAsFile(CoselmarServicesConfigOption.LOG_CONFIGURATION_FILE.key);
    }

    public boolean isDevMode() {
        boolean isDevMode = this.applicationConfig.getOptionAsBoolean(CoselmarServicesConfigOption.DEV_MODE.key);
        return isDevMode;
    }

    public String getApplicationUrl() {
        return this.applicationConfig.getOption(CoselmarServicesConfigOption.APPLICATION_URL.key);
    }

    public String getWebSecurityKey() {
        return this.applicationConfig.getOption(CoselmarServicesConfigOption.WEB_SECURITY_KEY.key);
    }

    public String getEncryptionAlgorithm() {
        return "SHA-256";
    }
}

