/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.log4j.producer;

import de.huxhorn.lilith.data.converter.Converter;
import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfoParser;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jLoggingConverter
implements Converter<de.huxhorn.lilith.data.logging.LoggingEvent> {
    public static final String LOG4J_LEVEL_KEY = "log4j.level";
    public static final String LOG4J_LEVEL_VALUE_FATAL = "FATAL";
    private static final String APPLICATION_MDC_KEY = "application";

    public de.huxhorn.lilith.data.logging.LoggingEvent convert(Object o) {
        String[] throwableStrRep;
        ThrowableInformation ti;
        LocationInfo location;
        String ndc;
        Map props;
        String threadName;
        if (o == null) {
            return null;
        }
        if (!(o instanceof LoggingEvent)) {
            throw new IllegalArgumentException("" + o + " is not a " + this.getSourceClass() + "!");
        }
        LoggingEvent log4jEvent = (LoggingEvent)o;
        de.huxhorn.lilith.data.logging.LoggingEvent result = new de.huxhorn.lilith.data.logging.LoggingEvent();
        HashMap<String, String> mdc = new HashMap<String, String>();
        result.setLogger(log4jEvent.getLoggerName());
        Level log4jLevel = log4jEvent.getLevel();
        if (log4jLevel.equals((Object)Level.TRACE)) {
            result.setLevel(LoggingEvent.Level.TRACE);
        } else if (log4jLevel.equals((Object)Level.DEBUG)) {
            result.setLevel(LoggingEvent.Level.DEBUG);
        } else if (log4jLevel.equals((Object)Level.INFO)) {
            result.setLevel(LoggingEvent.Level.INFO);
        } else if (log4jLevel.equals((Object)Level.WARN)) {
            result.setLevel(LoggingEvent.Level.WARN);
        } else if (log4jLevel.equals((Object)Level.ERROR)) {
            result.setLevel(LoggingEvent.Level.ERROR);
        } else if (log4jLevel.equals((Object)Level.FATAL)) {
            mdc.put(LOG4J_LEVEL_KEY, LOG4J_LEVEL_VALUE_FATAL);
            result.setLevel(LoggingEvent.Level.ERROR);
        }
        result.setTimeStamp(Long.valueOf(log4jEvent.getTimeStamp()));
        String msg = log4jEvent.getRenderedMessage();
        if (msg != null) {
            result.setMessage(new Message(msg));
        }
        if ((threadName = log4jEvent.getThreadName()) != null) {
            ThreadInfo threadInfo = new ThreadInfo();
            threadInfo.setName(threadName);
            result.setThreadInfo(threadInfo);
        }
        if ((props = log4jEvent.getProperties()) != null) {
            Iterator i$ = props.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry currentObj;
                Map.Entry current = currentObj = i$.next();
                String keyStr = null;
                String valueStr = null;
                Object key = current.getKey();
                Object value = current.getValue();
                if (key != null) {
                    keyStr = key.toString();
                }
                if (value != null) {
                    valueStr = value.toString();
                }
                if (keyStr == null || valueStr == null) continue;
                mdc.put(keyStr, valueStr);
            }
        }
        if (mdc.size() > 0) {
            result.setMdc(mdc);
        }
        if (mdc.containsKey(APPLICATION_MDC_KEY)) {
            LoggerContext context = new LoggerContext();
            context.setName((String)mdc.get(APPLICATION_MDC_KEY));
            result.setLoggerContext(context);
        }
        if ("".equals(ndc = log4jEvent.getNDC())) {
            ndc = null;
        }
        if (ndc != null) {
            result.setNdc(new Message[]{new Message(ndc)});
        }
        if ((location = log4jEvent.getLocationInformation()) != null) {
            ExtendedStackTraceElement ste = new ExtendedStackTraceElement();
            ste.setClassName(location.getClassName());
            ste.setMethodName(location.getMethodName());
            ste.setFileName(location.getFileName());
            String line = location.getLineNumber();
            if (line != null) {
                try {
                    ste.setLineNumber(Integer.parseInt(line));
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            result.setCallStack(new ExtendedStackTraceElement[]{ste});
        }
        if ((ti = log4jEvent.getThrowableInformation()) != null && (throwableStrRep = ti.getThrowableStrRep()) != null && throwableStrRep.length > 0) {
            result.setThrowable(ThrowableInfoParser.parse(Arrays.asList(throwableStrRep)));
        }
        return result;
    }

    public Class getSourceClass() {
        return LoggingEvent.class;
    }
}

