/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.jul.eventproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.impl.eventproducer.AbstractEventProducer;
import de.huxhorn.lilith.engine.impl.eventproducer.LoggingEventSourceIdentifierUpdater;
import de.huxhorn.lilith.engine.impl.eventproducer.SourceIdentifierUpdater;
import de.huxhorn.lilith.jul.xml.LoggingEventReader;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JulXmlStreamLoggingEventProducer
extends AbstractEventProducer<LoggingEvent> {
    private final Logger logger = LoggerFactory.getLogger(JulXmlStreamLoggingEventProducer.class);
    private LoggingEventReader loggingEventReader = new LoggingEventReader();
    private BufferedInputStream inputStream;

    public JulXmlStreamLoggingEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<LoggingEvent>> eventQueue, InputStream inputStream) {
        super(sourceIdentifier, eventQueue, (SourceIdentifierUpdater)new LoggingEventSourceIdentifierUpdater());
        this.inputStream = new BufferedInputStream(inputStream);
    }

    public void start() {
        Thread t = new Thread((Runnable)new ReceiverRunnable(), "" + this.getSourceIdentifier() + "-Receiver");
        t.setDaemon(true);
        t.start();
    }

    public void close() {
        IOUtilities.closeQuietly((InputStream)this.inputStream);
    }

    private class ReceiverRunnable
    implements Runnable {
        private ReceiverRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                try {
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                    inputFactory.setProperty("javax.xml.stream.supportDTD", false);
                    inputFactory.setProperty("javax.xml.stream.isValidating", false);
                    XMLStreamReader reader = inputFactory.createXMLStreamReader(new InputStreamReader((InputStream)JulXmlStreamLoggingEventProducer.this.inputStream, "utf-8"));
                    while (true) {
                        try {
                            while (true) {
                                LoggingEvent event;
                                if ((event = JulXmlStreamLoggingEventProducer.this.loggingEventReader.read(reader)) == null) {
                                    JulXmlStreamLoggingEventProducer.this.addEvent(null);
                                    break block11;
                                }
                                JulXmlStreamLoggingEventProducer.this.addEvent((Serializable)event);
                            }
                        }
                        catch (XMLStreamException ex) {
                            if (!JulXmlStreamLoggingEventProducer.this.logger.isWarnEnabled()) continue;
                            JulXmlStreamLoggingEventProducer.this.logger.warn("Exception while importing...", (Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    if (JulXmlStreamLoggingEventProducer.this.logger.isInfoEnabled()) {
                        JulXmlStreamLoggingEventProducer.this.logger.info("Exception ({}: '{}') while reading events. Adding eventWrapper with empty event and stopping...", new Object[]{e.getClass().getName(), e.getMessage(), e});
                    }
                    JulXmlStreamLoggingEventProducer.this.addEvent(null);
                    IOUtilities.interruptIfNecessary((Throwable)e);
                }
                finally {
                    JulXmlStreamLoggingEventProducer.this.close();
                }
            }
        }
    }
}

