/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.ironlist;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Focusable;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.provider.ArrayUpdater;
import com.vaadin.flow.data.provider.CompositeDataGenerator;
import com.vaadin.flow.data.provider.DataCommunicator;
import com.vaadin.flow.data.provider.DataGenerator;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.data.renderer.TemplateRenderer;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Tag(value="iron-list")
@NpmPackage(value="@polymer/iron-list", version="3.1.0")
@JsModule.Container(value={@JsModule(value="@polymer/iron-list/iron-list.js"), @JsModule(value="./flow-component-renderer.js"), @JsModule(value="./ironListConnector-es6.js"), @JsModule(value="./ironListStyles.js")})
@HtmlImport.Container(value={@HtmlImport(value="frontend://bower_components/iron-list/iron-list.html"), @HtmlImport(value="frontend://flow-component-renderer.html")})
@JavaScript(value="frontend://ironListConnector.js")
@StyleSheet(value="frontend://ironListStyles.css")
public class IronList<T>
extends Component
implements HasDataProvider<T>,
HasStyle,
HasSize,
Focusable<IronList<T>> {
    private final ArrayUpdater arrayUpdater = new ArrayUpdater(){

        public ArrayUpdater.Update startUpdate(int sizeChange) {
            return new UpdateQueue(sizeChange);
        }

        public void initialize() {
            IronList.this.initConnector();
        }
    };
    private final Element template;
    private Renderer<T> renderer;
    private String originalTemplate;
    private boolean rendererChanged;
    private boolean templateUpdateRegistered;
    private final CompositeDataGenerator<T> dataGenerator = new CompositeDataGenerator();
    private Registration dataGeneratorRegistration;
    private transient T placeholderItem;
    private final DataCommunicator<T> dataCommunicator = new DataCommunicator(this.dataGenerator, this.arrayUpdater, (SerializableConsumer & Serializable)data -> this.getElement().callJsFunction("$connector.updateData", new Serializable[]{data}), this.getElement().getNode());

    public IronList() {
        this.dataGenerator.addDataGenerator((DataGenerator & Serializable)(item, jsonObject) -> this.renderer.getValueProviders().forEach((property, provider) -> jsonObject.put(property, JsonSerializer.toJson((Object)provider.apply(item)))));
        this.template = new Element("template");
        this.getElement().appendChild(new Element[]{this.template});
        this.setRenderer(String::valueOf);
    }

    private void initConnector() {
        ((UI)this.getUI().orElseThrow(() -> new IllegalStateException("Connector can only be initialized for an attached IronList"))).getPage().executeJs("window.Vaadin.Flow.ironListConnector.initLazy($0)", new Serializable[]{this.getElement()});
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        Objects.requireNonNull(dataProvider, "The dataProvider cannot be null");
        this.getDataCommunicator().setDataProvider(dataProvider, null);
    }

    public DataProvider<T, ?> getDataProvider() {
        return this.getDataCommunicator().getDataProvider();
    }

    public DataCommunicator<T> getDataCommunicator() {
        return this.dataCommunicator;
    }

    public void setRenderer(ValueProvider<T, String> valueProvider) {
        Objects.requireNonNull(valueProvider, "The valueProvider must not be null");
        this.setRenderer((Renderer<T>)TemplateRenderer.of((String)"[[item.label]]").withProperty("label", valueProvider));
    }

    public void setRenderer(Renderer<T> renderer) {
        Rendering rendering;
        Objects.requireNonNull(renderer, "The renderer must not be null");
        if (this.dataGeneratorRegistration != null) {
            this.dataGeneratorRegistration.remove();
            this.dataGeneratorRegistration = null;
        }
        if ((rendering = renderer.render(this.getElement(), this.dataCommunicator.getKeyMapper(), this.template)).getDataGenerator().isPresent()) {
            this.dataGeneratorRegistration = this.dataGenerator.addDataGenerator((DataGenerator)rendering.getDataGenerator().get());
        }
        this.renderer = renderer;
        this.rendererChanged = true;
        this.registerTemplateUpdate();
        this.getDataCommunicator().reset();
    }

    public void setPlaceholderItem(T placeholderItem) {
        this.placeholderItem = placeholderItem;
        this.getElement().callJsFunction("$connector.setPlaceholderItem", new Serializable[]{JsonSerializer.toJson(placeholderItem)});
        this.registerTemplateUpdate();
    }

    public T getPlaceholderItem() {
        return this.placeholderItem;
    }

    private void registerTemplateUpdate() {
        if (this.templateUpdateRegistered) {
            return;
        }
        this.templateUpdateRegistered = true;
        this.runBeforeClientResponse((Command & Serializable)() -> this.runBeforeClientResponse((Command & Serializable)() -> this.updateTemplateInnerHtml()));
    }

    private void runBeforeClientResponse(Command command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getElement().getNode(), (SerializableConsumer & Serializable)context -> command.execute()));
    }

    private void updateTemplateInnerHtml() {
        String placeholderTemplate;
        this.templateUpdateRegistered = false;
        if (this.rendererChanged) {
            this.originalTemplate = this.template.getProperty("innerHTML");
            this.rendererChanged = false;
        }
        if (this.placeholderItem == null) {
            placeholderTemplate = "<div style='width:100px;height:18px'></div>";
        } else if (this.renderer instanceof ComponentRenderer) {
            ComponentRenderer componentRenderer = (ComponentRenderer)this.renderer;
            Component component = componentRenderer.createComponent(this.placeholderItem);
            component.getElement().setEnabled(this.isEnabled());
            placeholderTemplate = component.getElement().getOuterHTML();
        } else {
            placeholderTemplate = this.originalTemplate;
        }
        this.template.setProperty("innerHTML", String.format("<span><template is='dom-if' if='[[item.__placeholder]]'>%s</template><template is='dom-if' if='[[!item.__placeholder]]'>%s</template></span>", placeholderTemplate, this.originalTemplate));
    }

    public boolean isGridLayout() {
        return this.getElement().getProperty("grid", false);
    }

    public void setGridLayout(boolean gridLayout) {
        this.getElement().setProperty("grid", gridLayout);
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        this.setRenderer(this.renderer);
    }

    @ClientCallable(value=DisabledUpdateMode.ALWAYS)
    private void setRequestedRange(int start, int length) {
        this.getDataCommunicator().setRequestedRange(start, length);
    }

    private final class UpdateQueue
    implements ArrayUpdater.Update {
        private transient List<Runnable> queue = new ArrayList<Runnable>();

        private UpdateQueue(int size) {
            this.enqueue("$connector.updateSize", Integer.valueOf(size));
        }

        public void set(int start, List<JsonValue> items) {
            this.enqueue("$connector.set", Integer.valueOf(start), (Serializable)items.stream().collect(JsonUtils.asArray()));
        }

        public void clear(int start, int length) {
            this.enqueue("$connector.clear", Integer.valueOf(start), Integer.valueOf(length));
        }

        public void commit(int updateId) {
            IronList.this.getDataCommunicator().confirmUpdate(updateId);
            this.queue.forEach(Runnable::run);
            this.queue.clear();
        }

        private void enqueue(String name, Serializable ... arguments) {
            this.queue.add(() -> IronList.this.getElement().callJsFunction(name, arguments));
        }
    }
}

