/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.charts.Chart;
import com.vaadin.flow.component.charts.events.HasItem;
import com.vaadin.flow.component.charts.util.Util;
import java.time.Instant;

@DomEvent(value="point-drag-start")
public class PointDragStartEvent
extends ComponentEvent<Chart>
implements HasItem {
    private final String category;
    private final Instant start;
    private final Instant end;
    private final String parent;
    private final Double x;
    private final Double y;
    private final int seriesIndex;
    private final int pointIndex;
    private final String pointId;

    public PointDragStartEvent(Chart source, boolean fromClient, @EventData(value="event.detail.point.series.index") int seriesIndex, @EventData(value="event.detail.point.index") int pointIndex, @EventData(value="event.detail.point.id") String pointId, @EventData(value="event.detail.point.category") String category, @EventData(value="event.detail.point.start") Double start, @EventData(value="event.detail.point.end") Double end, @EventData(value="event.detail.point.parent") String parent, @EventData(value="event.detail.point.x") Double x, @EventData(value="event.detail.point.y") Double y) {
        super((Component)source, fromClient);
        this.seriesIndex = seriesIndex;
        this.pointIndex = pointIndex;
        this.pointId = pointId;
        this.category = category;
        this.start = start != null ? Util.toServerInstant(start) : null;
        this.end = end != null ? Util.toServerInstant(end) : null;
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public int getItemIndex() {
        return this.pointIndex;
    }

    @Override
    public String getItemId() {
        return this.pointId;
    }

    @Override
    public int getSeriesItemIndex() {
        return this.seriesIndex;
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public String getParent() {
        return this.parent;
    }

    public Double getxValue() {
        return this.x;
    }

    public Double getyValue() {
        return this.y;
    }
}

