/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public class Util {
    public static final int EOF = -1;

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        Util.copyLarge(in, out, new byte[1000]);
        return out.toString("UTF-8");
    }

    public static long copyLarge(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static String getHash(String content, byte[] salt, Charset charset) {
        if (content == null || content.isEmpty()) {
            return "";
        }
        return Util.bytesToHex(Util.sha256(content, salt, charset));
    }

    public static String removeTrailingSlash(String url) {
        Objects.requireNonNull(url);
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String validateURL(String url) {
        URI uri;
        try {
            uri = new URL(url).toURI();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URL " + url + ": " + e.getMessage(), e);
        }
        String protocol = uri.getScheme();
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("Invalid URL " + url);
        }
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            throw new IllegalArgumentException("Invalid URL " + url + ". Protocol must be http or https");
        }
        return url;
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder result = new StringBuilder();
        for (byte hashByte : hash) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                result.append('0');
            }
            result.append(hex);
        }
        return result.toString();
    }

    private static byte[] sha256(String string, byte[] salt, Charset charset) {
        return Util.getSha256(salt).digest(string.getBytes(charset));
    }

    private static MessageDigest getSha256(byte[] salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            assert (digest.getDigestLength() == 32);
            if (salt != null && salt.length > 0) {
                digest.update(salt);
            }
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("Your Java implementation does not support SHA-256, even though it is required by the Java specification. Change to an implementation which follows the specification.", e);
        }
    }
}

