/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.experimental.CoreFeatureFlagProvider;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.AbstractConfiguration;
import com.vaadin.flow.server.Mode;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import java.util.Enumeration;

public interface ApplicationConfiguration
extends AbstractConfiguration {
    public static ApplicationConfiguration get(VaadinContext context) {
        return context.getAttribute(ApplicationConfiguration.class, () -> {
            Lookup lookup = context.getAttribute(Lookup.class);
            if (lookup == null) {
                throw new IllegalStateException("The application " + Lookup.class.getSimpleName() + " instance is not found in " + VaadinContext.class.getSimpleName() + ". The instance is supposed to be created by a ServletContainerInitializer. Issues known to cause this problem are:\n- A Spring Boot application deployed as a war-file but the main application class does not extend SpringBootServletInitializer\n- An embedded server that is not set up to execute ServletContainerInitializers\n- Unit tests which do not properly set up the context for the test\n");
            }
            ApplicationConfigurationFactory factory = lookup.lookup(ApplicationConfigurationFactory.class);
            if (factory == null) {
                return null;
            }
            return factory.create(context);
        });
    }

    public Enumeration<String> getPropertyNames();

    public VaadinContext getContext();

    public boolean isDevModeSessionSerializationEnabled();

    default public boolean disableAutomaticServletRegistration() {
        return this.getBooleanProperty("disable.automatic.servlet.registration", false);
    }

    @Override
    default public Mode getMode() {
        Mode defaultMode = AbstractConfiguration.super.getMode();
        if (!defaultMode.equals((Object)Mode.DEVELOPMENT_BUNDLE)) {
            return defaultMode;
        }
        FeatureFlags featureFlags = FeatureFlags.get(this.getContext());
        if (featureFlags.isEnabled(CoreFeatureFlagProvider.TAILWIND_CSS)) {
            return Mode.DEVELOPMENT_FRONTEND_LIVERELOAD;
        }
        return defaultMode;
    }
}

