/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.i18n;

import com.vaadin.flow.i18n.DefaultI18NProvider;
import com.vaadin.flow.i18n.I18NProvider;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.SynchronizedRequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.IOException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslationFileRequestHandler
extends SynchronizedRequestHandler {
    static final String LANGUAGE_TAG_PARAMETER_NAME = "langtag";
    static final String RETRIEVED_LOCALE_HEADER_NAME = "X-Vaadin-Retrieved-Locale";
    private static final Locale FALLBACK_LOCALE = Locale.ROOT;
    private final DefaultI18NProvider i18NProvider;
    private final boolean hasFallbackBundle;

    public TranslationFileRequestHandler(I18NProvider i18NProvider) {
        boolean hasDefaultI18NProvider = i18NProvider != null && DefaultI18NProvider.class.equals(i18NProvider.getClass());
        this.i18NProvider = hasDefaultI18NProvider ? (DefaultI18NProvider)i18NProvider : null;
        this.hasFallbackBundle = this.hasFallbackBundle();
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (this.i18NProvider == null) {
            this.handleCustomI18NProvider(session, response);
            return true;
        }
        Locale locale = this.getLocale(request);
        ResourceBundle translationPropertyFile = this.getTranslationPropertyFile(locale);
        if (translationPropertyFile == null) {
            this.handleNotFound(response);
        } else {
            this.handleFound(response, translationPropertyFile);
        }
        return true;
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        return HandlerHelper.isRequestType(request, HandlerHelper.RequestType.TRANSLATION_FILE);
    }

    private void handleFound(VaadinResponse response, ResourceBundle translationPropertyFile) throws IOException {
        response.setStatus(HttpStatusCode.OK.getCode());
        response.setHeader(RETRIEVED_LOCALE_HEADER_NAME, translationPropertyFile.getLocale().toLanguageTag());
        response.setHeader("Content-Type", "application/json; charset=UTF-8");
        this.writeFileToResponse(response, translationPropertyFile);
    }

    private void handleNotFound(VaadinResponse response) {
        response.setStatus(HttpStatusCode.NOT_FOUND.getCode());
    }

    private void handleCustomI18NProvider(VaadinSession session, VaadinResponse response) throws IOException {
        String errorMessage = "Loading translations is not supported when using a custom i18n provider.";
        if (session.getService().getDeploymentConfiguration().isProductionMode()) {
            response.setStatus(HttpStatusCode.NOT_FOUND.getCode());
        } else {
            response.sendError(HttpStatusCode.NOT_IMPLEMENTED.getCode(), errorMessage);
        }
        this.getLogger().debug(errorMessage);
    }

    private void writeFileToResponse(VaadinResponse response, ResourceBundle translationPropertyFile) throws IOException {
        JsonObject json = Json.createObject();
        translationPropertyFile.keySet().forEach(key -> json.put(key, translationPropertyFile.getString((String)key)));
        response.getWriter().write(json.toJson());
    }

    private Locale getLocale(VaadinRequest request) {
        String languageTag = Objects.requireNonNullElse(request.getParameter(LANGUAGE_TAG_PARAMETER_NAME), "");
        if (languageTag.contains("_")) {
            String[] tokens = languageTag.split("_");
            String language = tokens[0];
            String country = tokens.length > 1 ? tokens[1] : "";
            String variant = tokens.length > 2 ? tokens[2] : "";
            return new Locale(language, country, variant);
        }
        return Locale.forLanguageTag(languageTag);
    }

    private ResourceBundle getTranslationPropertyFile(Locale locale) {
        Locale bestMatchLocale = this.getBestMatchLocale(locale);
        if (bestMatchLocale == null) {
            if (FALLBACK_LOCALE.equals(locale)) {
                this.getLogger().debug("Missing the requested default bundle for {}.", (Object)"vaadin-i18n.translations");
            } else {
                this.getLogger().debug("Missing resource bundles for {}, both the requested locale {} and the default bundle.", (Object)"vaadin-i18n.translations", (Object)locale.getDisplayName());
            }
            return null;
        }
        if (!locale.equals(bestMatchLocale)) {
            if (FALLBACK_LOCALE.equals(bestMatchLocale)) {
                this.getLogger().debug("Missing resource bundle for {} and locale {}. Using the default bundle.", (Object)"vaadin-i18n.translations", (Object)locale.getDisplayName());
            } else {
                this.getLogger().debug("Missing resource bundle for {} and locale {}. Using the best match locale {}.", new Object[]{"vaadin-i18n.translations", locale.getDisplayName(), bestMatchLocale.getDisplayName()});
            }
        }
        return this.i18NProvider.getBundle(bestMatchLocale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    private Locale getBestMatchLocale(Locale locale) {
        Set<Locale> providedLocales = Set.copyOf(this.i18NProvider.getProvidedLocales());
        if (providedLocales.contains(locale)) {
            return locale;
        }
        Optional<Locale> languageAndCountryMatch = providedLocales.stream().filter(providedLocale -> providedLocale.getLanguage().equals(locale.getLanguage()) && providedLocale.getCountry().equals(locale.getCountry())).findAny();
        if (languageAndCountryMatch.isPresent()) {
            return languageAndCountryMatch.get();
        }
        Optional<Locale> languageMatch = providedLocales.stream().filter(providedLocale -> providedLocale.getLanguage().equals(locale.getLanguage())).findAny();
        if (languageMatch.isPresent()) {
            return languageMatch.get();
        }
        if (this.hasFallbackBundle) {
            return FALLBACK_LOCALE;
        }
        return null;
    }

    private boolean hasFallbackBundle() {
        if (this.i18NProvider != null) {
            try {
                this.i18NProvider.getBundle(FALLBACK_LOCALE, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES));
                return true;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return false;
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(TranslationFileRequestHandler.class);
    }
}

