/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.dnd;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.dnd.DragSource;
import com.vaadin.flow.component.dnd.DropEffect;

@DomEvent(value="dragend")
public class DragEndEvent<T extends Component>
extends ComponentEvent<T> {
    private final DropEffect dropEffect;

    public DragEndEvent(T source, boolean fromClient, @EventData(value="event.dataTransfer.dropEffect") String dropEffect) {
        super(source, fromClient);
        this.dropEffect = DropEffect.fromString(dropEffect);
    }

    public DropEffect getDropEffect() {
        return this.dropEffect;
    }

    public boolean isSuccessful() {
        return this.getDropEffect() != DropEffect.NONE;
    }

    public T getComponent() {
        return (T)this.getSource();
    }

    public void clearDragData() {
        DragSource.configure(this.getComponent()).setDragData(null);
    }
}

