/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.validator;

import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.validator.AbstractValidator;
import com.vaadin.flow.data.validator.RangeValidator;

public class StringLengthValidator
extends AbstractValidator<String> {
    private final RangeValidator<Integer> validator;

    public StringLengthValidator(String errorMessage, Integer minLength, Integer maxLength) {
        super(errorMessage);
        this.validator = RangeValidator.of(errorMessage, minLength, maxLength);
    }

    @Override
    public ValidationResult apply(String value, ValueContext context) {
        if (value == null) {
            return this.toResult(value, true);
        }
        ValidationResult lengthCheck = this.validator.apply((Integer)value.length(), context);
        return this.toResult(value, !lengthCheck.isError());
    }

    public Integer getMaxLength() {
        return this.validator.getMaxValue();
    }

    public Integer getMinLength() {
        return this.validator.getMinValue();
    }

    public void setMaxLength(Integer maxLength) {
        this.validator.setMaxValue(maxLength);
    }

    public void setMinLength(Integer minLength) {
        this.validator.setMaxValue(minLength);
    }

    public String toString() {
        return String.format("%s[%d, %d]", this.getClass().getSimpleName(), this.getMinLength(), this.getMaxLength());
    }
}

