/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.neo4j;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.impls.Parameter;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jElement;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jGraph;
import com.tinkerpop.blueprints.pgm.impls.neo4j.Neo4jIndex;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.PropertyContainer;

public class Neo4jAutomaticIndex<T extends Neo4jElement, S extends PropertyContainer>
extends Neo4jIndex<T, S>
implements AutomaticIndex<T> {
    Set<String> autoIndexKeys;

    public Neo4jAutomaticIndex(String name, Class<T> indexClass, Neo4jGraph graph, Set<String> keys, Parameter ... indexParameters) {
        super(name, indexClass, graph, indexParameters);
        if (!this.loadKeyField()) {
            if (null != keys) {
                this.autoIndexKeys = new HashSet<String>();
                this.autoIndexKeys.addAll(keys);
            }
            this.saveKeyField();
        }
    }

    @Override
    public Index.Type getIndexType() {
        return Index.Type.AUTOMATIC;
    }

    protected void autoUpdate(String key, Object newValue, Object oldValue, T element) {
        if (null == this.autoIndexKeys || this.autoIndexKeys.contains(key)) {
            if (oldValue != null) {
                this.removeBasic(key, oldValue, element);
            }
            this.putBasic(key, newValue, element);
        }
    }

    protected void autoRemove(String key, Object oldValue, T element) {
        if (null == this.autoIndexKeys || this.autoIndexKeys.contains(key)) {
            this.removeBasic(key, oldValue, element);
        }
    }

    public Set<String> getAutoIndexKeys() {
        return this.autoIndexKeys;
    }

    private void saveKeyField() {
        try {
            String field;
            if (null != this.autoIndexKeys) {
                field = "";
                for (String key : this.autoIndexKeys) {
                    field = field + "!=!" + key;
                }
            } else {
                field = "null";
            }
            this.getIndexManager().setConfiguration(this.rawIndex, "_blueprints:autokeys", field);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean loadKeyField() {
        String keysString = (String)this.getIndexManager().getConfiguration(this.rawIndex).get("_blueprints:autokeys");
        if (null != keysString) {
            if (keysString.equals("null")) {
                this.autoIndexKeys = null;
            } else {
                this.autoIndexKeys = new HashSet<String>();
                for (String key : keysString.split("!=!")) {
                    if (key.length() <= 0) continue;
                    this.autoIndexKeys.add(key);
                }
            }
            return true;
        }
        return false;
    }
}

