/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached.storage.hash;

import com.thimbleware.jmemcached.storage.CacheStorage;
import com.thimbleware.jmemcached.storage.hash.SizedItem;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConcurrentLinkedHashMap<K, V extends SizedItem>
extends AbstractMap<K, V>
implements Serializable,
CacheStorage<K, V> {
    private static final EvictionListener<?, ?> nullListener = new EvictionListener<Object, Object>(){

        @Override
        public void onEviction(Object key, Object value) {
        }
    };
    private static final long serialVersionUID = 8350170357874293408L;
    final ConcurrentMap<K, Node<K, V>> data;
    final EvictionListener<K, V> listener;
    final AtomicInteger capacity;
    final EvictionPolicy policy;
    final AtomicInteger length;
    final Node<K, V> sentinel;
    final Lock lock;
    final AtomicLong memoryCapacity;
    final AtomicLong memoryUsed;

    public static <K, V extends SizedItem> ConcurrentLinkedHashMap<K, V> create(EvictionPolicy policy, int maximumCapacity, long maximumMemoryCapacity) {
        return ConcurrentLinkedHashMap.create(policy, maximumCapacity, maximumMemoryCapacity, 16, nullListener);
    }

    public static <K, V extends SizedItem> ConcurrentLinkedHashMap<K, V> create(EvictionPolicy policy, int maximumCapacity, long maximumMemoryCapacity, EvictionListener<K, V> listener) {
        return ConcurrentLinkedHashMap.create(policy, maximumCapacity, maximumMemoryCapacity, 16, listener);
    }

    public static <K, V extends SizedItem> ConcurrentLinkedHashMap<K, V> create(EvictionPolicy policy, int maximumCapacity, long maximumMemoryCapacity, int concurrencyLevel) {
        return ConcurrentLinkedHashMap.create(policy, maximumCapacity, maximumMemoryCapacity, concurrencyLevel, nullListener);
    }

    public static <K, V extends SizedItem> ConcurrentLinkedHashMap<K, V> create(EvictionPolicy policy, int maximumCapacity, long maximumMemoryCapacity, int concurrencyLevel, EvictionListener<K, V> listener) {
        return new ConcurrentLinkedHashMap<K, V>(policy, maximumCapacity, maximumMemoryCapacity, concurrencyLevel, listener);
    }

    private ConcurrentLinkedHashMap(EvictionPolicy policy, int maximumCapacity, long maximumMemoryCapacity, int concurrencyLevel, EvictionListener<K, V> listener) {
        if (policy == null || maximumCapacity < 0 || concurrencyLevel <= 0 || listener == null) {
            throw new IllegalArgumentException();
        }
        this.data = new ConcurrentHashMap<K, Node<K, V>>(maximumCapacity, 0.75f, concurrencyLevel);
        this.capacity = new AtomicInteger(maximumCapacity);
        this.length = new AtomicInteger();
        this.listener = listener;
        this.policy = policy;
        this.lock = new ReentrantLock();
        this.sentinel = new Node(this.lock);
        this.memoryUsed = new AtomicLong(0L);
        this.memoryCapacity = new AtomicLong(maximumMemoryCapacity);
    }

    private boolean isOverflow() {
        return this.size() > this.capacity() || this.getMemoryUsed() > this.getMemoryCapacity();
    }

    @Override
    public long getMemoryCapacity() {
        return this.memoryCapacity.get();
    }

    @Override
    public long getMemoryUsed() {
        return this.memoryUsed.get();
    }

    public void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity.set(capacity);
        while (this.evict()) {
        }
    }

    public void setMemoryCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.memoryCapacity.set(capacity);
        while (this.evict()) {
        }
    }

    @Override
    public int capacity() {
        return this.capacity.get();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public int size() {
        int size = this.length.get();
        return size >= 0 ? size : 0;
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            this.remove(key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        return this.data.containsValue(new Node<Object, Object>(null, value, null, this.lock));
    }

    private boolean evict() {
        while (this.isOverflow()) {
            Node<K, V> node = this.sentinel.getNext();
            if (node == this.sentinel) {
                return false;
            }
            if (!this.policy.onEvict(this, node) || !this.data.remove(node.getKey(), new Identity(node))) continue;
            this.length.decrementAndGet();
            this.memoryUsed.addAndGet(-1 * ((SizedItem)node.getValue()).size());
            node.remove();
            this.listener.onEviction(node.getKey(), node.getValue());
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Node node = (Node)this.data.get(key);
        if (node != null) {
            this.policy.onAccess(this, node);
            return (V)((SizedItem)node.getValue());
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node<K, V> old = this.putIfAbsent(new Node<K, V>(key, value, this.sentinel, this.lock));
        this.memoryUsed.addAndGet(value.size());
        if (old == null) {
            return null;
        }
        this.memoryUsed.addAndGet(-1 * ((SizedItem)old.getValue()).size());
        return (V)((SizedItem)old.getAndSetValue(value));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node<K, V> old = this.putIfAbsent(new Node<K, V>(key, value, this.sentinel, this.lock));
        if (old == null) {
            this.memoryUsed.addAndGet(value.size());
            return null;
        }
        return (V)((SizedItem)old.getValue());
    }

    private Node<K, V> putIfAbsent(Node<K, V> node) {
        Node<K, V> old = this.data.putIfAbsent(node.getKey(), node);
        if (old == null) {
            this.length.incrementAndGet();
            node.appendToTail();
            this.evict();
        } else {
            this.policy.onAccess(this, old);
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        Node node = (Node)this.data.remove(key);
        if (node == null) {
            return null;
        }
        this.length.decrementAndGet();
        this.memoryUsed.addAndGet(-1 * ((SizedItem)node.getValue()).size());
        node.remove();
        return (V)((SizedItem)node.getValue());
    }

    @Override
    public boolean remove(Object key, Object value) {
        Node node = (Node)this.data.get(key);
        if (node != null && ((SizedItem)node.value).equals(value) && this.data.remove(key, new Identity(node))) {
            this.length.decrementAndGet();
            this.memoryUsed.addAndGet(-1 * ((SizedItem)node.getValue()).size());
            node.remove();
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return null;
        }
        this.memoryUsed.addAndGet(-1 * ((SizedItem)node.getValue()).size());
        this.memoryUsed.addAndGet(value.size());
        return (V)((SizedItem)node.getAndSetValue(value));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException();
        }
        Node node = (Node)this.data.get(key);
        if (node == null) {
            return false;
        }
        boolean val = node.casValue(oldValue, newValue);
        if (val) {
            this.memoryUsed.addAndGet(-1 * oldValue.size());
            this.memoryUsed.addAndGet(newValue.size());
        }
        return val;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry<K, V> e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return SimpleEntry.eq(this.key, entry.getKey()) && SimpleEntry.eq(this.value, entry.getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NodeEntry
    implements Map.Entry<K, V> {
        private final ConcurrentLinkedHashMap<K, V> map;
        private final Node<K, V> node;

        public NodeEntry(Node<K, V> node) {
            this.map = ConcurrentLinkedHashMap.this;
            this.node = node;
        }

        @Override
        public K getKey() {
            return this.node.getKey();
        }

        @Override
        public V getValue() {
            Object value;
            if (this.node.isUnlinked() && (value = this.map.get(this.getKey())) != null) {
                return value;
            }
            return (SizedItem)this.node.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.map.replace(this.getKey(), value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.eq(this.getKey(), entry.getKey()) && this.eq(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            Object key = this.getKey();
            Object value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Node<K, V>> iterator;
        private Map.Entry<K, V> current;

        public EntryIterator(Iterator<Node<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = new NodeEntry(this.iterator.next());
            return this.current;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            ConcurrentLinkedHashMap.this.remove(this.current.getKey(), this.current.getValue());
            this.current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map.data.values().iterator());
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && ((SizedItem)node.value).equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), (SizedItem)entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return this.map.remove(entry.getKey(), entry.getValue());
        }

        @Override
        public Object[] toArray() {
            ArrayList entries = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                entries.add(new SimpleEntry(entry));
            }
            return entries.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            ArrayList entries = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                entries.add(new SimpleEntry(entry));
            }
            return entries.toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    implements Iterator<V> {
        private final EntryIterator iterator;

        private ValueIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return (SizedItem)this.iterator.next().getValue();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<V> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private Values() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public Object[] toArray() {
            ArrayList<SizedItem> values = new ArrayList<SizedItem>(this.size());
            for (SizedItem value : this) {
                values.add(value);
            }
            return values.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            ArrayList<SizedItem> values = new ArrayList<SizedItem>(this.size());
            for (SizedItem value : this) {
                values.add(value);
            }
            return values.toArray(array);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    implements Iterator<K> {
        private final EntryIterator iterator;

        private KeyIterator() {
            this.iterator = new EntryIterator(ConcurrentLinkedHashMap.this.data.values().iterator());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private final ConcurrentLinkedHashMap<K, V> map;

        private KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return this.map.containsKey(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return this.map.remove(obj) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            return this.map.data.keySet().toArray(array);
        }
    }

    private static final class Identity {
        private final Object delegate;

        public Identity(Object delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object o) {
            return o == this.delegate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class Node<K, V>
    implements Serializable {
        private static final long serialVersionUID = 1461281468985304519L;
        private static final AtomicReferenceFieldUpdater<Node, Object> valueUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "value");
        private static final Node UNLINKED = new Node(null);
        private final K key;
        private final Lock lock;
        private final Node<K, V> sentinel;
        private volatile V value;
        private volatile boolean marked;
        private volatile Node<K, V> prev;
        private volatile Node<K, V> next;

        public Node(Lock lock) {
            this.sentinel = this;
            this.value = null;
            this.lock = lock;
            this.prev = this;
            this.next = this;
            this.key = null;
        }

        public Node(K key, V value, Node<K, V> sentinel, Lock lock) {
            this.sentinel = sentinel;
            this.next = UNLINKED;
            this.prev = UNLINKED;
            this.value = value;
            this.lock = lock;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void appendToTail() {
            this.lock.lock();
            try {
                this.next = this.sentinel;
                Node<K, V> tail = this.sentinel.prev;
                this.sentinel.prev = this;
                tail.next = this;
                this.prev = tail;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            while (true) {
                if (this.isUnlinked()) {
                    continue;
                }
                this.lock.lock();
                try {
                    if (this.isUnlinked()) continue;
                    this.prev.next = this.next;
                    this.next.prev = this.prev;
                    this.next = UNLINKED;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void moveToTail() {
            if (this.isTail() || this.isUnlinked()) {
                return;
            }
            this.lock.lock();
            try {
                if (this.isTail() || this.isUnlinked()) {
                    return;
                }
                this.prev.next = this.next;
                this.next.prev = this.prev;
                this.next = this.sentinel;
                this.prev = this.sentinel.prev;
                this.sentinel.prev = this;
                this.prev.next = this;
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean isUnlinked() {
            return this.next == UNLINKED;
        }

        public boolean isTail() {
            return this.next == this.sentinel;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return (V)valueUpdater.get(this);
        }

        public V getAndSetValue(V value) {
            return (V)valueUpdater.getAndSet(this, value);
        }

        public boolean casValue(V expect, V update) {
            return valueUpdater.compareAndSet(this, expect, update);
        }

        public Node<K, V> getPrev() {
            return this.prev;
        }

        public Node<K, V> getNext() {
            return this.next;
        }

        public boolean isMarked() {
            return this.marked;
        }

        public void setMarked(boolean marked) {
            this.marked = marked;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Node)) {
                return false;
            }
            V value = this.getValue();
            Node node = (Node)obj;
            return value == null ? node.getValue() == null : value.equals(node.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            this.lock.lock();
            try {
                String string = String.format("key=%s - prev=%s ; next=%s", this.valueOf(this.key), this.valueOf(this.prev.key), this.valueOf(this.next.key));
                return string;
            }
            finally {
                this.lock.unlock();
            }
        }

        private String valueOf(K key) {
            return key == null ? "sentinel" : key.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvictionPolicy {
        FIFO{

            @Override
            <K, V extends SizedItem> void onAccess(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
            }

            @Override
            <K, V extends SizedItem> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                return true;
            }
        }
        ,
        SECOND_CHANCE{

            @Override
            <K, V extends SizedItem> void onAccess(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                node.setMarked(true);
            }

            @Override
            <K, V extends SizedItem> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                if (node.isMarked()) {
                    node.moveToTail();
                    node.setMarked(false);
                    return false;
                }
                return true;
            }
        }
        ,
        LRU{

            @Override
            <K, V extends SizedItem> void onAccess(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                node.moveToTail();
            }

            @Override
            <K, V extends SizedItem> boolean onEvict(ConcurrentLinkedHashMap<K, V> map, Node<K, V> node) {
                return true;
            }
        };


        abstract <K, V extends SizedItem> void onAccess(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);

        abstract <K, V extends SizedItem> boolean onEvict(ConcurrentLinkedHashMap<K, V> var1, Node<K, V> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EvictionListener<K, V> {
        public void onEviction(K var1, V var2);
    }
}

