/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.protocol.xml.server;

import com.sun.xml.ws.encoding.xml.XMLMessage;
import com.sun.xml.ws.handler.XMLHandlerContext;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.protocol.xml.server.XMLMessageDispatcher;
import com.sun.xml.ws.server.RuntimeContext;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.provider.ProviderPeptTie;
import com.sun.xml.ws.util.MessageInfoUtil;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;

public class ProviderXMLMD
extends XMLMessageDispatcher {
    protected void toMessageInfo(MessageInfo messageInfo, XMLHandlerContext context) {
        Object[] data = new Object[1];
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        Provider provider = (Provider)endpointInfo.getImplementor();
        Class<?> providerClass = provider.getClass();
        boolean isSource = ProviderXMLMD.isSource(providerClass);
        boolean isDataSource = ProviderXMLMD.isDataSource(providerClass);
        if (!isSource && !isDataSource) {
            throw new UnsupportedOperationException("Endpoint should implement Provider<Source> or Provider<DataSource>");
        }
        Service.Mode mode = ProviderXMLMD.getServiceMode(providerClass);
        if (mode == Service.Mode.PAYLOAD && isDataSource) {
            throw new UnsupportedOperationException("Illeagal combination Mode.PAYLOAD and Provider<DataSource>");
        }
        XMLMessage xmlMessage = context.getXMLMessage();
        try {
            data[0] = isSource ? xmlMessage.getSource() : xmlMessage.getDataSource();
        }
        catch (Exception e) {
            messageInfo.setResponseType(2);
            messageInfo.setResponse(e);
        }
        messageInfo.setData(data);
        messageInfo.setMethod(ProviderPeptTie.invoke_Method);
    }

    protected void setResponseInContext(MessageInfo messageInfo, XMLHandlerContext context) {
        Object obj = messageInfo.getResponse();
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeEndpointInfo endpointInfo = rtCtxt.getRuntimeEndpointInfo();
        Provider provider = (Provider)endpointInfo.getImplementor();
        Class<?> providerClass = provider.getClass();
        boolean useFastInfoset = messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation") == "optimistic";
        XMLMessage xmlMessage = null;
        xmlMessage = messageInfo.getResponseType() == 0 ? (obj instanceof DataSource ? new XMLMessage((DataSource)obj, useFastInfoset) : new XMLMessage((Source)obj, useFastInfoset)) : new XMLMessage((Exception)obj, useFastInfoset);
        context.setXMLMessage(xmlMessage);
        context.setInternalMessage(null);
    }

    protected void invokeEndpoint(MessageInfo messageInfo, XMLHandlerContext hc) {
        super.invokeEndpoint(messageInfo, hc);
        if (ProviderXMLMD.isOneway(messageInfo)) {
            this.sendResponseOneway(messageInfo);
        }
    }

    private static Service.Mode getServiceMode(Class c) {
        ServiceMode mode = c.getAnnotation(ServiceMode.class);
        if (mode == null) {
            return Service.Mode.PAYLOAD;
        }
        return mode.value();
    }

    private static boolean isSource(Class c) {
        try {
            c.getMethod("invoke", Source.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    private static boolean isDataSource(Class c) {
        try {
            c.getMethod("invoke", DataSource.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

