/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.handler;

import com.sun.xml.ws.encoding.jaxb.JAXBBeanInfo;
import com.sun.xml.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.ws.encoding.jaxb.JAXBTypeSerializer;
import com.sun.xml.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.ws.encoding.soap.SOAPEPTFactory;
import com.sun.xml.ws.encoding.soap.SOAPEncoder;
import com.sun.xml.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.ws.handler.HandlerContext;
import com.sun.xml.ws.handler.SOAPHandlerContext;
import com.sun.xml.ws.pept.ept.MessageInfo;
import com.sun.xml.ws.util.xml.XmlUtil;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Node;

public class LogicalMessageImpl
implements LogicalMessage {
    private SOAPHandlerContext ctxt;

    public LogicalMessageImpl(SOAPHandlerContext ctxt) {
        this.ctxt = ctxt;
    }

    public Source getPayload() {
        try {
            BodyBlock bodyBlock;
            InternalMessage internalMessage = this.ctxt.getInternalMessage();
            if (internalMessage == null) {
                SOAPMessage soapMessage = this.ctxt.getSOAPMessage();
                if (soapMessage == null) {
                    return null;
                }
                Node node = soapMessage.getSOAPBody().getFirstChild();
                if (node != null) {
                    this.setSource(new DOMSource(node));
                } else {
                    return null;
                }
            }
            if ((bodyBlock = (internalMessage = this.ctxt.getInternalMessage()).getBody()) == null) {
                return null;
            }
            Object obj = bodyBlock.getValue();
            if (obj instanceof DOMSource) {
                return (Source)obj;
            }
            if (obj instanceof Source) {
                Source source = (Source)obj;
                Transformer transformer = XmlUtil.newTransformer();
                DOMResult domResult = new DOMResult();
                transformer.transform(source, domResult);
                DOMSource domSource = new DOMSource(domResult.getNode());
                bodyBlock.setSource(domSource);
                return domSource;
            }
            if (obj instanceof JAXBBridgeInfo) {
                MessageInfo messageInfo = this.ctxt.getMessageInfo();
                SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                SOAPEncoder encoder = eptf.getSOAPEncoder();
                DOMSource domSource = encoder.toDOMSource((JAXBBridgeInfo)obj, messageInfo);
                bodyBlock.setSource(domSource);
                return domSource;
            }
            if (obj instanceof JAXBBeanInfo) {
                DOMSource domSource = ((JAXBBeanInfo)obj).toDOMSource();
                bodyBlock.setSource(domSource);
                return domSource;
            }
            if (obj instanceof RpcLitPayload) {
                MessageInfo messageInfo = this.ctxt.getMessageInfo();
                SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                SOAPEncoder encoder = eptf.getSOAPEncoder();
                DOMSource domSource = encoder.toDOMSource((RpcLitPayload)obj, messageInfo);
                bodyBlock.setSource(domSource);
                return domSource;
            }
            if (obj instanceof SOAPFaultInfo) {
                MessageInfo messageInfo = this.ctxt.getMessageInfo();
                SOAPEPTFactory eptf = (SOAPEPTFactory)((Object)messageInfo.getEPTFactory());
                SOAPEncoder encoder = eptf.getSOAPEncoder();
                DOMSource domSource = encoder.toDOMSource((SOAPFaultInfo)obj, messageInfo);
                bodyBlock.setSource(domSource);
                return domSource;
            }
            throw new WebServiceException("Unknown type " + obj.getClass() + " in BodyBlock");
        }
        catch (TransformerException te) {
            throw new WebServiceException((Throwable)te);
        }
        catch (SOAPException se) {
            throw new WebServiceException((Throwable)se);
        }
    }

    public void setPayload(Source source) {
        this.setSource(source);
    }

    public Object getPayload(JAXBContext jaxbContext) {
        return JAXBTypeSerializer.deserialize(this.getPayload(), jaxbContext);
    }

    public void setPayload(Object bean, JAXBContext jaxbContext) {
        DOMSource source;
        try {
            source = JAXBTypeSerializer.serialize(bean, jaxbContext);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        this.setSource(source);
    }

    public HandlerContext getHandlerContext() {
        return this.ctxt;
    }

    private void setSource(Source source) {
        BodyBlock bodyBlock;
        InternalMessage internalMessage = this.ctxt.getInternalMessage();
        if (internalMessage == null) {
            internalMessage = new InternalMessage();
            this.ctxt.setInternalMessage(internalMessage);
        }
        if ((bodyBlock = internalMessage.getBody()) == null) {
            bodyBlock = new BodyBlock(source);
            internalMessage.setBody(bodyBlock);
        } else {
            bodyBlock.setSource(source);
        }
    }
}

