/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.xml.ws.binding.http.HTTPBindingImpl;
import com.sun.xml.ws.binding.soap.SOAPBindingImpl;
import com.sun.xml.ws.client.BindingProviderProperties;
import com.sun.xml.ws.client.EndpointIFContext;
import com.sun.xml.ws.client.EndpointIFInvocationHandler;
import com.sun.xml.ws.client.InternalBindingProvider;
import com.sun.xml.ws.client.PortInfoBase;
import com.sun.xml.ws.client.ServiceContext;
import com.sun.xml.ws.client.ServiceContextBuilder;
import com.sun.xml.ws.client.dispatch.DispatchBase;
import com.sun.xml.ws.handler.PortInfoImpl;
import com.sun.xml.ws.model.RuntimeModel;
import com.sun.xml.ws.spi.runtime.StubBase;
import com.sun.xml.ws.util.xml.XmlUtil;
import com.sun.xml.ws.wsdl.WSDLContext;
import com.sun.xml.ws.wsdl.parser.Binding;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.spi.ServiceDelegate;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServiceDelegate
extends ServiceDelegate {
    protected static final String GET = "get";
    protected HashSet<QName> ports;
    protected HashMap<QName, PortInfoBase> dispatchPorts;
    protected HandlerResolver handlerResolver;
    protected Object serviceProxy;
    protected URL wsdlLocation;
    protected ServiceContext serviceContext;
    protected Executor executor;
    private HashSet<Object> seiProxies;
    private EntityResolver entityResolver;

    public WSServiceDelegate(ServiceContext scontext) {
        this.serviceContext = scontext;
        this.dispatchPorts = new HashMap();
        this.seiProxies = new HashSet();
        if (this.serviceContext.getHandlerResolver() != null) {
            this.handlerResolver = this.serviceContext.getHandlerResolver();
        }
    }

    public WSServiceDelegate(URL wsdlDocumentLocation, QName serviceName, Class serviceClass) {
        this.dispatchPorts = new HashMap();
        this.seiProxies = new HashSet();
        if (wsdlDocumentLocation != null) {
            this.serviceContext = ServiceContextBuilder.build(wsdlDocumentLocation, serviceClass, XmlUtil.createDefaultCatalogResolver());
        } else {
            this.serviceContext = new ServiceContext(XmlUtil.createDefaultCatalogResolver());
            this.serviceContext.setServiceName(serviceName);
        }
        if (this.serviceContext.getHandlerResolver() != null) {
            this.handlerResolver = this.serviceContext.getHandlerResolver();
        }
        if (this.ports == null) {
            this.populatePorts();
        }
    }

    private void processServiceContext(QName portName, Class portInterface) throws WebServiceException {
        ServiceContextBuilder.completeServiceContext(this.serviceContext, portInterface);
    }

    public URL getWSDLLocation() {
        if (this.wsdlLocation == null) {
            this.setWSDLLocation(this.getWsdlLocation());
        }
        return this.wsdlLocation;
    }

    public void setWSDLLocation(URL location) {
        this.wsdlLocation = location;
    }

    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = Executors.newFixedThreadPool(3, new DaemonThreadFactory());
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public HandlerResolver getHandlerResolver() {
        return this.handlerResolver;
    }

    public void setHandlerResolver(HandlerResolver resolver) {
        this.handlerResolver = resolver;
    }

    public Object getPort(QName portName, Class portInterface) throws WebServiceException {
        Object seiProxy = this.createEndpointIFBaseProxy(portName, portInterface);
        this.seiProxies.add(seiProxy);
        if (portName != null) {
            this.addPort(portName);
        }
        return seiProxy;
    }

    public Object getPort(Class portInterface) throws WebServiceException {
        return this.createEndpointIFBaseProxy(null, portInterface);
    }

    public void addPort(QName portName, String bindingId, String endpointAddress) throws WebServiceException {
        if (this.dispatchPorts.containsKey(portName)) {
            throw new WebServiceException("Port " + portName.toString() + " already exists can not create a port with the same name.");
        }
        this.dispatchPorts.put(portName, new PortInfoBase(endpointAddress, portName, bindingId));
        this.addPort(portName);
    }

    public <T> Dispatch<T> createDispatch(QName qName, Class<T> aClass, Service.Mode mode) throws WebServiceException {
        return this.createDispatchClazz(qName, aClass, mode);
    }

    public Dispatch<Object> createDispatch(QName qName, JAXBContext jaxbContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatchJAXB(qName, jaxbContext, mode);
    }

    public QName getServiceName() {
        return this.serviceContext.getServiceName();
    }

    public Iterator getPorts() throws WebServiceException {
        if (this.ports == null) {
            this.populatePorts();
        }
        if (this.ports.size() == 0) {
            throw this.noWsdlException();
        }
        return this.ports.iterator();
    }

    public URL getWSDLDocumentLocation() {
        return this.getWsdlLocation();
    }

    protected void addPorts(QName[] ports) {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                this.addPort(ports[i]);
            }
        }
    }

    private void populatePorts() {
        QName serviceName;
        if (this.ports == null) {
            this.ports = new HashSet();
        }
        WSDLContext wscontext = this.serviceContext.getWsdlContext();
        if (this.serviceContext.getServiceName() == null && wscontext != null) {
            this.serviceContext.setServiceName(wscontext.getFirstServiceName());
        }
        Set<QName> knownPorts = null;
        if (wscontext != null && (knownPorts = wscontext.getPortsAsSet(serviceName = this.serviceContext.getServiceName())) != null) {
            QName[] portz = knownPorts.toArray(new QName[knownPorts.size()]);
            this.addPorts(portz);
            for (QName port : portz) {
                String endpoint = wscontext.getEndpoint(serviceName, port);
                String bid = wscontext.getWsdlBinding(serviceName, port).getBindingId();
                this.dispatchPorts.put(port, new PortInfoBase(endpoint, port, bid));
            }
        }
    }

    protected void addPort(QName port) {
        if (this.ports == null) {
            this.populatePorts();
        }
        this.ports.add(port);
    }

    protected WebServiceException noWsdlException() {
        return new WebServiceException("dii.service.no.wsdl.available");
    }

    private Object createEndpointIFBaseProxy(QName portName, Class portInterface) throws WebServiceException {
        this.processServiceContext(portName, portInterface);
        if (portName == null) {
            portName = this.serviceContext.getEndpointIFContext(portInterface.getName()).getPortName();
        }
        if (!this.serviceContext.getWsdlContext().contains(this.getServiceName(), portName)) {
            throw new WebServiceException("Port " + portName + "is not found in service " + this.serviceContext.getServiceName());
        }
        return this.buildEndpointIFProxy(portName, portInterface);
    }

    protected HashSet<QName> getPortsAsSet() {
        if (this.ports == null) {
            this.populatePorts();
        }
        return this.ports;
    }

    protected void setBindingOnProvider(InternalBindingProvider provider, QName portName, String bindingId) {
        List<Object> handlerChain = null;
        if (this.getHandlerResolver() != null && this.getServiceName() != null) {
            PortInfoImpl portInfo = new PortInfoImpl(bindingId.toString(), portName, this.getServiceName());
            handlerChain = this.getHandlerResolver().getHandlerChain((PortInfo)portInfo);
        } else {
            handlerChain = new ArrayList<Handler>();
        }
        if (bindingId.toString().equals("http://schemas.xmlsoap.org/wsdl/soap/http") || bindingId.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            SOAPBindingImpl bindingImpl = new SOAPBindingImpl(handlerChain, bindingId.toString(), this.getServiceName());
            if (this.serviceContext.getRoles(portName) != null) {
                bindingImpl.setRoles(this.serviceContext.getRoles(portName));
            }
            provider._setBinding(bindingImpl);
        } else if (bindingId.toString().equals("http://www.w3.org/2004/08/wsdl/http")) {
            provider._setBinding(new HTTPBindingImpl(handlerChain));
        }
    }

    private Dispatch createDispatchClazz(QName port, Class clazz, Service.Mode mode) throws WebServiceException {
        PortInfoBase dispatchPort = this.dispatchPorts.get(port);
        if (dispatchPort != null) {
            DispatchBase dBase = new DispatchBase(dispatchPort, clazz, mode, this);
            this.setBindingOnProvider(dBase, port, dBase._getBindingId());
            return dBase;
        }
        throw new WebServiceException("Port must be defined in order to create Dispatch");
    }

    private Dispatch createDispatchJAXB(QName port, JAXBContext jaxbContext, Service.Mode mode) throws WebServiceException {
        PortInfoBase dispatchPort = this.dispatchPorts.get(port);
        if (dispatchPort != null) {
            DispatchBase dBase = new DispatchBase(dispatchPort, jaxbContext, mode, this);
            this.setBindingOnProvider(dBase, port, dBase._getBindingId());
            return dBase;
        }
        throw new WebServiceException("Port must be defined in order to create Dispatch");
    }

    private URL getWsdlLocation() {
        return this.serviceContext.getWsdlContext().getWsdlLocation();
    }

    private Object buildEndpointIFProxy(QName portQName, Class portInterface) throws WebServiceException {
        EndpointIFContext eif = this.completeEndpointIFContext(this.serviceContext, portQName, portInterface);
        RuntimeModel model = eif.getRuntimeContext().getModel();
        if (portQName != null) {
            Binding binding = this.serviceContext.getWsdlContext().getWsdlBinding(this.serviceContext.getServiceName(), portQName);
            eif.setBindingID(binding.getBindingId());
            model.applyParameterBinding(binding);
        }
        EndpointIFInvocationHandler handler = new EndpointIFInvocationHandler(portInterface, eif, this, this.getServiceName());
        this.setBindingOnProvider(handler, portQName, handler._getBindingId());
        Object proxy = Proxy.newProxyInstance(portInterface.getClassLoader(), new Class[]{portInterface, BindingProvider.class, BindingProviderProperties.class, StubBase.class}, (InvocationHandler)handler);
        handler.setProxy(proxy);
        return (BindingProvider)proxy;
    }

    private EndpointIFContext completeEndpointIFContext(ServiceContext serviceContext, QName portQName, Class portInterface) {
        EndpointIFContext context = serviceContext.getEndpointIFContext(portInterface.getName());
        WSDLContext wscontext = serviceContext.getWsdlContext();
        if (wscontext != null) {
            String endpoint = wscontext.getEndpoint(serviceContext.getServiceName(), portQName);
            String bindingID = wscontext.getBindingID(serviceContext.getServiceName(), portQName);
            context.setServiceName(serviceContext.getServiceName());
            context.setPortInfo(portQName, endpoint, bindingID);
        }
        return context;
    }

    class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread daemonThread = new Thread(r);
            daemonThread.setDaemon(Boolean.TRUE);
            return daemonThread;
        }
    }
}

