/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.naming;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.naming.CorruptedConfigurationPropertiesException;
import com.sun.messaging.naming.MissingVersionNumberException;
import com.sun.messaging.naming.UnsupportedVersionNumberException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class AdministeredObjectFactory
implements ObjectFactory {
    protected static final String REF_VERSION = "version";
    protected static final String REF_READONLY = "readOnly";
    protected static final String AO_VERSION_STR = "3.0";
    protected static final String AO_VERSION_STR_JMQ3B = "2.1";
    protected static final String AO_VERSION_STR_JMQ2 = "2.0";
    protected static final String AO_VERSION_STR_JMQ1 = "1.1";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            String string = null;
            boolean bl = false;
            Object obj = Class.forName(reference.getClassName()).newInstance();
            RefAddr refAddr = reference.get(REF_VERSION);
            if (refAddr == null || !(obj instanceof AdministeredObject)) {
                throw new MissingVersionNumberException();
            }
            string = (String)refAddr.getContent();
            if (!(AO_VERSION_STR.equals(string) || AO_VERSION_STR_JMQ3B.equals(string) || AO_VERSION_STR_JMQ2.equals(string))) {
                throw new UnsupportedVersionNumberException(string);
            }
            if (reference.size() < 2) {
                throw new CorruptedConfigurationPropertiesException();
            }
            RefAddr refAddr2 = reference.get(REF_READONLY);
            if ("true".equals((String)refAddr2.getContent())) {
                bl = true;
            }
            ((AdministeredObject)obj).storedVersion = string;
            for (int i = 2; i < reference.size(); ++i) {
                refAddr2 = reference.get(i);
                String string2 = (String)refAddr2.getContent();
                if (string2 == null) {
                    string2 = "";
                }
                try {
                    ((AdministeredObject)obj).setProperty(refAddr2.getType(), string2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl) {
                ((AdministeredObject)obj).setReadOnly();
            }
            return obj;
        }
        return null;
    }
}

