/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.BytesMessageImpl;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MapMessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ObjectMessageImpl;
import com.sun.messaging.jmq.jmsclient.StreamMessageImpl;
import com.sun.messaging.jmq.jmsclient.TextMessageImpl;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;

public class MessageConvert {
    protected static final MessageConvert messageConvert = new MessageConvert();

    public static synchronized MessageConvert getInstance() {
        return messageConvert;
    }

    protected Message convertJMSMessage(Message message) throws JMSException {
        Object object = null;
        object = message instanceof TextMessage ? this.convertTextMessage((TextMessage)message) : (message instanceof MapMessage ? this.convertMapMessage((MapMessage)message) : (message instanceof BytesMessage ? this.convertBytesMessage((BytesMessage)message) : (message instanceof ObjectMessage ? this.convertObjectMessage((ObjectMessage)message) : (message instanceof StreamMessage ? this.convertStreamMessage((StreamMessage)message) : new MessageImpl()))));
        this.convertJMSHeader((Message)object, message);
        this.convertJMSProperties((Message)object, message);
        return object;
    }

    protected void convertJMSHeader(Message message, Message message2) throws JMSException {
        message.setJMSCorrelationID(message2.getJMSCorrelationID());
        message.setJMSType(message.getJMSType());
    }

    protected void resetForeignMessageHeader(Message message, Message message2) throws JMSException {
        message2.setJMSDeliveryMode(message.getJMSDeliveryMode());
        message2.setJMSExpiration(message.getJMSExpiration());
        message2.setJMSMessageID(message.getJMSMessageID());
        message2.setJMSPriority(message.getJMSPriority());
        message2.setJMSTimestamp(message.getJMSTimestamp());
        message2.setJMSDestination(message.getJMSDestination());
    }

    protected void convertJMSProperties(Message message, Message message2) throws JMSException {
        Enumeration enumeration = message2.getPropertyNames();
        String string = null;
        Object object = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = message2.getObjectProperty(string);
            message.setObjectProperty(string, object);
        }
    }

    protected Message convertTextMessage(TextMessage textMessage) throws JMSException {
        TextMessageImpl textMessageImpl = new TextMessageImpl();
        textMessageImpl.setText(textMessage.getText());
        return textMessageImpl;
    }

    protected Message convertMapMessage(MapMessage mapMessage) throws JMSException {
        MapMessageImpl mapMessageImpl = new MapMessageImpl();
        String string = null;
        Enumeration enumeration = mapMessage.getMapNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            mapMessageImpl.setObject(string, mapMessage.getObject(string));
        }
        return mapMessageImpl;
    }

    protected Message convertBytesMessage(BytesMessage bytesMessage) throws JMSException {
        BytesMessageImpl bytesMessageImpl = new BytesMessageImpl(true);
        byte by = 0;
        bytesMessage.reset();
        try {
            while (true) {
                by = bytesMessage.readByte();
                bytesMessageImpl.writeByte(by);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4070");
        }
        return bytesMessageImpl;
    }

    protected Message convertObjectMessage(ObjectMessage objectMessage) throws JMSException {
        ObjectMessageImpl objectMessageImpl = new ObjectMessageImpl();
        objectMessageImpl.setObject(objectMessage.getObject());
        return objectMessageImpl;
    }

    protected Message convertStreamMessage(StreamMessage streamMessage) throws JMSException {
        StreamMessageImpl streamMessageImpl = new StreamMessageImpl(true);
        Object object = null;
        streamMessage.reset();
        try {
            while (true) {
                object = streamMessage.readObject();
                streamMessageImpl.writeObject(object);
            }
        }
        catch (MessageEOFException messageEOFException) {
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4070");
        }
        return streamMessageImpl;
    }
}

