/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Locale;
import org.sagacity.sqltoy.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberUtil {
    private static final Logger logger = LoggerFactory.getLogger(NumberUtil.class);
    private static final String INTEGER_REGEX = "^[+-]?[\\d]+$";
    private static final String NUMBER_REGEX = "^[+-]?[\\d]+(\\.\\d+)?$";
    protected final BigDecimal ONE_BIGDECIMAL = new BigDecimal(1);
    private static final String[] moneyUOM = new String[]{"\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4eac"};
    private static final String[] numUOM = new String[]{"\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u5146", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4ebf", "\u5341", "\u767e", "\u5343", "\u4e07", "\u5341", "\u767e", "\u5343", "\u4eac"};
    private static final String[] capitalMoneyNumber = new String[]{"", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] captialNumber = new String[]{"", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};

    private NumberUtil() {
    }

    public static String format(Object target, String pattern) {
        return NumberUtil.format(target, pattern, null, null);
    }

    public static String format(Object target, String pattern, RoundingMode roundingMode, Locale locale) {
        if (target == null) {
            return null;
        }
        if (pattern == null) {
            return target.toString();
        }
        try {
            String tmpStr = target.toString().replace(",", "").trim().toLowerCase();
            if ("".equals(tmpStr) || "null".equals(tmpStr) || "nan".equals(tmpStr)) {
                return "";
            }
            BigDecimal tmp = new BigDecimal(tmpStr);
            String lowPattern = pattern.toLowerCase();
            if (lowPattern.equals("capital")) {
                return NumberUtil.numberToChina(tmpStr, false);
            }
            if (lowPattern.equals("capitalmoney") || lowPattern.equals("capital-rmb")) {
                return NumberUtil.toCapitalMoney(tmp);
            }
            if (lowPattern.equals("capital-en") || lowPattern.equals("capital-english")) {
                return NumberUtil.convertToEnglishMoney(tmp);
            }
            DecimalFormat df = (DecimalFormat)(locale == null ? DecimalFormat.getInstance() : DecimalFormat.getInstance(locale));
            if (roundingMode != null) {
                df.setRoundingMode(roundingMode);
            }
            df.applyPattern(pattern);
            return df.format(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("value:" + target + ";pattern=" + pattern + e.getMessage());
            return target.toString();
        }
    }

    public static String formatCurrency(Object target, String pattern, Locale locale) {
        if (target == null) {
            return null;
        }
        if (pattern == null) {
            return target.toString();
        }
        try {
            String tmpStr = target.toString().replace(",", "").trim().toLowerCase();
            if ("".equals(tmpStr) || "null".equals(tmpStr) || "nan".equals(tmpStr)) {
                return "";
            }
            String lowPattern = pattern.toLowerCase();
            BigDecimal tmp = new BigDecimal(tmpStr);
            if (lowPattern.equals("capital")) {
                return NumberUtil.numberToChina(tmpStr, false);
            }
            if (lowPattern.equals("capitalmoney") || lowPattern.equals("capital-rmb")) {
                return NumberUtil.toCapitalMoney(tmp);
            }
            if (lowPattern.equals("capital-en") || lowPattern.equals("capital-english")) {
                return NumberUtil.convertToEnglishMoney(tmp);
            }
            DecimalFormat df = (DecimalFormat)(locale == null ? DecimalFormat.getCurrencyInstance() : DecimalFormat.getCurrencyInstance(locale));
            df.applyPattern(pattern);
            return df.format(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            return target.toString();
        }
    }

    public static Float parsePercent(String percent) {
        if (StringUtil.isBlank(percent)) {
            return null;
        }
        NumberFormat nf = NumberFormat.getPercentInstance();
        try {
            return Float.valueOf(nf.parse(percent).floatValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Float parseFloat(String floatStr, Integer maxIntDigits, Integer maxFractionDigits) {
        Number number = NumberUtil.parseStr(floatStr, maxIntDigits, null, maxFractionDigits, null);
        if (number != null) {
            return Float.valueOf(number.floatValue());
        }
        return null;
    }

    public static BigDecimal parseDecimal(String decimalStr, Integer maxIntDigits, Integer maxFractionDigits) {
        Number number = NumberUtil.parseStr(decimalStr, maxIntDigits, null, maxFractionDigits, null);
        if (number != null) {
            return new BigDecimal(number.doubleValue());
        }
        return null;
    }

    public static Double parseDouble(String doubleStr, Integer maxIntDigits, Integer maxFractionDigits) {
        Number number = NumberUtil.parseStr(doubleStr, maxIntDigits, null, maxFractionDigits, null);
        if (number != null) {
            return number.doubleValue();
        }
        return null;
    }

    public static BigDecimal capitalMoneyToNum(String capitalMoney) {
        capitalMoney = capitalMoney.replaceAll("\\s+", "").replace("\u96f6", "").replace("\u5706", "\u5143");
        int scale = 3;
        if (capitalMoney.endsWith("\u6574")) {
            capitalMoney = capitalMoney.replace("\u6574", "");
            scale = 0;
        }
        capitalMoney = capitalMoney.trim();
        for (int i = 0; i < 9; ++i) {
            capitalMoney = capitalMoney.replace(capitalMoneyNumber[i + 1], Integer.toString(i + 1));
        }
        int billionIndex = capitalMoney.lastIndexOf("\u4ebf");
        String[] splitsCapitalMoney = new String[]{"0", "0", "0"};
        if (billionIndex != -1) {
            splitsCapitalMoney[0] = capitalMoney.substring(0, billionIndex);
            splitsCapitalMoney[1] = capitalMoney.substring(billionIndex + 1, capitalMoney.indexOf("\u5143"));
        } else if (capitalMoney.indexOf("\u5143") != -1) {
            splitsCapitalMoney[1] = capitalMoney.substring(0, capitalMoney.indexOf("\u5143"));
        }
        if (capitalMoney.indexOf("\u5143") != capitalMoney.length() - 1) {
            splitsCapitalMoney[2] = capitalMoney.substring(capitalMoney.indexOf("\u5143") + 1);
        }
        BigDecimal result = NumberUtil.parseMillMoney(splitsCapitalMoney[0]).multiply(new BigDecimal("100000000")).add(NumberUtil.parseMillMoney(splitsCapitalMoney[1])).add(NumberUtil.parseLowThousandMoney(splitsCapitalMoney[2]));
        if (capitalMoney.indexOf("\u8d1f") == 0) {
            return new BigDecimal(0).subtract(result).setScale(scale, RoundingMode.HALF_UP);
        }
        return result.setScale(scale, RoundingMode.HALF_UP);
    }

    public static String toCapitalMoney(BigDecimal money) {
        String result;
        BigDecimal realMoney = money.setScale(5, RoundingMode.HALF_UP).abs();
        if (realMoney.compareTo(new BigDecimal(0)) == 0) {
            return "\u96f6\u5143";
        }
        String sourceStr = realMoney.toString();
        int dotIndex = sourceStr.indexOf(".");
        String intPartStr = dotIndex == -1 ? sourceStr : sourceStr.substring(0, dotIndex);
        String decimalPartStr = "";
        if (dotIndex != -1) {
            decimalPartStr = sourceStr.substring(dotIndex + 1);
        }
        if ((result = NumberUtil.numberToChina(intPartStr, true)).startsWith("\u58f9\u62fe")) {
            result = result.substring(1);
        }
        if (!"".equals(result)) {
            result = result + "\u5143";
        }
        if (money.compareTo(new BigDecimal("0")) < 0) {
            result = "\u8d1f" + result;
        }
        if (dotIndex == -1 || "".equals(decimalPartStr) || Integer.parseInt(decimalPartStr) == 0) {
            result = result + "\u6574";
        } else {
            String[] uomName = new String[]{"\u89d2", "\u5206", "\u5398"};
            boolean hasZero = false;
            String dotPartStr = "";
            int dotPartSize = decimalPartStr.length() > 3 ? 3 : decimalPartStr.length();
            for (int i = dotPartSize - 1; i >= 0; --i) {
                int indexValue = Integer.valueOf(decimalPartStr.substring(i, i + 1));
                if (indexValue != 0) {
                    dotPartStr = capitalMoneyNumber[indexValue] + uomName[i] + dotPartStr;
                    hasZero = true;
                    continue;
                }
                if (!hasZero) continue;
                dotPartStr = "\u96f6" + dotPartStr;
                hasZero = false;
            }
            result = result + dotPartStr;
        }
        return result;
    }

    public static String numberToChina(int sourceInt) {
        return NumberUtil.numberToChina(Integer.toString(sourceInt), false);
    }

    public static BigDecimal getMax(BigDecimal[] bigArray) {
        BigDecimal max = bigArray[0];
        for (int i = 0; i < bigArray.length; ++i) {
            if (max.compareTo(bigArray[i]) >= 0) continue;
            max = bigArray[i];
        }
        return max;
    }

    public static BigDecimal getMin(BigDecimal[] bigArray) {
        BigDecimal min = bigArray[0];
        for (int i = 0; i < bigArray.length; ++i) {
            if (min.compareTo(bigArray[i]) <= 0) continue;
            min = bigArray[i];
        }
        return min;
    }

    public static BigDecimal getAverage(BigDecimal[] bigArray) {
        BigDecimal sum = BigDecimal.ZERO;
        if (bigArray == null || bigArray.length == 0) {
            return sum;
        }
        for (int i = 0; i < bigArray.length; ++i) {
            sum = sum.add(bigArray[i]);
        }
        return sum.divide(new BigDecimal(bigArray.length));
    }

    public static BigDecimal summary(BigDecimal[] bigArray) {
        BigDecimal sum = BigDecimal.ZERO;
        if (bigArray == null || bigArray.length == 0) {
            return sum;
        }
        for (int i = 0; i < bigArray.length; ++i) {
            sum = sum.add(bigArray[i]);
        }
        return sum;
    }

    private static Number parseStr(String parseTarget, Integer maxIntDigits, Integer minIntDigits, Integer maxFractionDigits, Integer minFractionDigits) {
        if (StringUtil.isBlank(parseTarget)) {
            return null;
        }
        NumberFormat nf = NumberFormat.getInstance();
        try {
            if (maxIntDigits != null) {
                nf.setMaximumIntegerDigits(maxIntDigits);
            }
            if (minIntDigits != null) {
                nf.setMinimumIntegerDigits(minIntDigits);
            }
            if (maxFractionDigits != null) {
                nf.setMaximumFractionDigits(maxFractionDigits);
            }
            if (minFractionDigits != null) {
                nf.setMinimumFractionDigits(minFractionDigits);
            }
            return nf.parse(parseTarget.replace(",", ""));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BigDecimal parseMillMoney(String capitalMoneyStr) {
        if ("".equals(capitalMoneyStr) || "0".equals(capitalMoneyStr)) {
            return BigDecimal.ZERO;
        }
        String millStr = "0";
        String lowthousand = "0";
        int millIndex = capitalMoneyStr.indexOf("\u4e07");
        if (millIndex != -1) {
            millStr = capitalMoneyStr.substring(0, millIndex);
            lowthousand = millIndex != capitalMoneyStr.length() - 1 ? capitalMoneyStr.substring(millIndex + 1) : "0";
        } else {
            lowthousand = capitalMoneyStr;
        }
        return NumberUtil.parseLowThousandMoney(millStr).multiply(new BigDecimal("10000")).add(NumberUtil.parseLowThousandMoney(lowthousand));
    }

    private static String numberToChina(String sourceInt, boolean isMoney) {
        if ("0".equals(sourceInt)) {
            return "";
        }
        String[] chinaNum = isMoney ? capitalMoneyNumber : captialNumber;
        String[] realUOM = isMoney ? moneyUOM : numUOM;
        int length = sourceInt.length();
        StringBuilder targetStr = new StringBuilder("");
        for (int i = 0; i < length; ++i) {
            String firstChar = targetStr.length() > 0 ? String.valueOf(targetStr.charAt(0)) : "\u96f6";
            int temp = Integer.parseInt(sourceInt.substring(length - i - 1, length - i));
            if (temp == 0) {
                if (i > 0 && i % 4 == 0) {
                    if ("\u4e07\u4ebf\u5146\u4eac".indexOf(firstChar) != -1) {
                        targetStr.delete(0, 1);
                    }
                    targetStr.insert(0, numUOM[i - 1]);
                    continue;
                }
                if ("\u96f6\u4e07\u4ebf\u5146\u4eac".indexOf(firstChar) != -1) continue;
                targetStr.insert(0, "\u96f6");
                continue;
            }
            if (i > 0 && i % 4 == 0 && "\u4e07\u4ebf\u5146\u4eac".indexOf(firstChar) != -1) {
                targetStr.delete(0, 1);
            }
            targetStr.insert(0, chinaNum[temp] + (i > 0 ? realUOM[i - 1] : ""));
        }
        return targetStr.toString();
    }

    private static BigDecimal parseLowThousandMoney(String capitalMoneyStr) {
        if ("0".equals(capitalMoneyStr)) {
            return BigDecimal.ZERO;
        }
        String lastStr = capitalMoneyStr.substring(capitalMoneyStr.length() - 1);
        int lastAscii = StringUtil.str2ASCII(lastStr)[0];
        String[] uoms = new String[]{"\u4edf", "\u4f70", "\u62fe", "\u89d2", "\u5206", "\u5398"};
        double[] multiples = new double[]{1000.0, 100.0, 10.0, 0.1, 0.01, 0.001};
        BigDecimal moneyNum = BigDecimal.ZERO;
        for (int i = 0; i < uoms.length; ++i) {
            int index = capitalMoneyStr.indexOf(uoms[i]);
            if (index == -1) continue;
            double splitMoneyNum = Double.parseDouble(capitalMoneyStr.substring(index - 1, index)) * multiples[i];
            moneyNum = moneyNum.add(new BigDecimal(splitMoneyNum));
        }
        if (lastAscii >= 49 && lastAscii <= 57) {
            moneyNum = moneyNum.add(new BigDecimal(lastStr));
        }
        return moneyNum;
    }

    public static boolean isInteger(String obj) {
        return StringUtil.matches(obj, INTEGER_REGEX);
    }

    public static boolean isNumber(String numberStr) {
        return StringUtil.matches(numberStr, NUMBER_REGEX);
    }

    public static int getRandomNum(int max) {
        return NumberUtil.getRandomNum(0, max);
    }

    public static int getRandomNum(int start, int end) {
        long value = Math.abs(new SecureRandom().nextLong()) % (long)(end - start);
        return Long.valueOf(value + (long)start).intValue();
    }

    public static Object[] randomArray(int maxValue, int size) {
        int realSize = size;
        if (realSize > maxValue) {
            realSize = maxValue;
        }
        if (realSize == maxValue) {
            Object[] result = new Object[maxValue];
            for (int i = 0; i < maxValue; ++i) {
                result[i] = i;
            }
            return result;
        }
        HashSet<Integer> resultSet = new HashSet<Integer>(realSize);
        while (resultSet.size() < realSize) {
            int randomNum = (int)(Math.random() * (double)maxValue);
            resultSet.add(randomNum);
        }
        return resultSet.toArray();
    }

    public static int getProbabilityIndex(int[] probabilities) {
        int total = 0;
        for (int probabilitiy : probabilities) {
            total += probabilitiy;
        }
        int randomData = (int)(Math.random() * (double)total) + 1;
        int base = 0;
        for (int i = 0; i < probabilities.length; ++i) {
            if (randomData > base && randomData <= base + probabilities[i]) {
                return i;
            }
            base += probabilities[i];
        }
        return 0;
    }

    public static String convertToEnglishMoney(BigDecimal value) {
        if (null == value) {
            return "";
        }
        String str = value.toString();
        int dotIndex = str.indexOf(".");
        if (dotIndex != -1 && str.length() > dotIndex + 3) {
            str = str.substring(0, dotIndex + 3);
        }
        return NumberUtil.convertToEnglishMoney(str);
    }

    public static String convertToEnglishMoney(String value) {
        String lstr;
        boolean hasPermil;
        if (value == null) {
            return null;
        }
        boolean isMinus = false;
        if (value.startsWith("-")) {
            isMinus = true;
            value = value.substring(1);
        }
        if (hasPermil = value.contains(",")) {
            value = value.replace(",", "");
        }
        int z = value.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = value.substring(0, z);
            rstr = value.substring(z + 1);
        } else {
            lstr = value;
        }
        String lstrrev = NumberUtil.reverse(lstr);
        String[] a = new String[5];
        switch (lstrrev.length() % 3) {
            case 1: {
                lstrrev = lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = lstrrev + "0";
                break;
            }
        }
        StringBuilder lm = new StringBuilder();
        int loopEnd = lstrrev.length() / 3;
        for (int i = 0; i < loopEnd; ++i) {
            a[i] = NumberUtil.reverse(lstrrev.substring(3 * i, 3 * i + 3));
            if (!"000".equals(a[i])) {
                if (i != 0) {
                    if (hasPermil && lm.length() > 0) {
                        lm.insert(0, NumberUtil.transThree(a[i]) + " " + NumberUtil.parseMore(String.valueOf(i)) + ",");
                        continue;
                    }
                    lm.insert(0, NumberUtil.transThree(a[i]) + " " + NumberUtil.parseMore(String.valueOf(i)) + " ");
                    continue;
                }
                lm = new StringBuilder(NumberUtil.transThree(a[i]));
                continue;
            }
            lm.append(NumberUtil.transThree(a[i]));
        }
        String xs = "";
        xs = z > -1 && BigDecimal.ZERO.compareTo(new BigDecimal(rstr)) == -1 ? " AND CENTS " + NumberUtil.transTwo(rstr) : " AND CENTS";
        return (isMinus ? "MINUS " : "") + lm.toString().trim() + xs + " ONLY";
    }

    private static String parseFirst(String s) {
        String[] a = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
        return a[Integer.parseInt(s.substring(s.length() - 1))];
    }

    private static String parseTeen(String s) {
        String[] a = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
        return a[Integer.parseInt(s) - 10];
    }

    private static String parseTen(String s) {
        String[] a = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
        return a[Integer.parseInt(s.substring(0, 1)) - 1];
    }

    private static String transTwo(String s) {
        String value = "";
        if (s.length() > 2) {
            s = s.substring(0, 2);
        } else if (s.length() < 2) {
            s = "0" + s;
        }
        value = s.startsWith("0") ? NumberUtil.parseFirst(s) : (s.startsWith("1") ? NumberUtil.parseTeen(s) : (s.endsWith("0") ? NumberUtil.parseTen(s) : NumberUtil.parseTen(s) + "-" + NumberUtil.parseFirst(s)));
        return value;
    }

    private static String parseMore(String s) {
        String[] a = new String[]{"", "THOUSAND", "MILLION", "BILLION", "TRILLION", "QUADRILLION"};
        return a[Integer.parseInt(s)];
    }

    private static String transThree(String s) {
        String value = "";
        value = s.startsWith("0") ? NumberUtil.transTwo(s.substring(1)) : ("00".equals(s.substring(1)) ? NumberUtil.parseFirst(s.substring(0, 1)) + " HUNDRED" : NumberUtil.parseFirst(s.substring(0, 1)) + " HUNDRED AND " + NumberUtil.transTwo(s.substring(1)));
        return value;
    }

    private static String reverse(String s) {
        char[] aChr = s.toCharArray();
        StringBuffer tmp = new StringBuffer();
        for (int i = aChr.length - 1; i >= 0; --i) {
            tmp.append(aChr[i]);
        }
        return tmp.toString();
    }

    public static final class Pattern {
        public static final String CAPITAL = "capital";
        public static final String CAPITAL_MONEY = "capitalmoney";
        public static final String CAPITAL_RMB = "capital-rmb";
        public static final String CAPITAL_EN = "capital-en";
        public static final String CAPITAL_ENGLISH = "capital-english";
    }
}

