/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.model;

import java.io.Serializable;
import org.sagacity.sqltoy.model.CacheArg;
import org.sagacity.sqltoy.model.DateType;
import org.sagacity.sqltoy.model.Exclusive;
import org.sagacity.sqltoy.model.TimeUnit;
import org.sagacity.sqltoy.utils.StringUtil;

public class ParamsFilter
implements Serializable {
    private static final long serialVersionUID = 1976248512731692880L;
    private String type;
    private String dataType;
    private String compareType;
    private String[] compareValues;
    private String[] params;
    private Object[] value;
    private String[] assignParams;
    private String assignValue;
    private String[] excludes;
    private int increase = 0;
    private TimeUnit timeUnit = TimeUnit.DAYS;
    private String dateType;
    private String asName;
    private String addQueto;
    private CacheArg cacheArg;

    public ParamsFilter(String ... params) {
        this.params = params;
    }

    public ParamsFilter blank() {
        this.type = "blank";
        return this;
    }

    public ParamsFilter eq(Object ... values) {
        this.type = "eq";
        this.value = values;
        return this;
    }

    public ParamsFilter neq(Object ... values) {
        this.type = "neq";
        this.value = values;
        return this;
    }

    public ParamsFilter gt(Object values) {
        this.type = "gt";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter gte(Object values) {
        this.type = "gte";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter lt(Object values) {
        this.type = "lt";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter lte(Object values) {
        this.type = "lte";
        this.value = new Object[]{values};
        return this;
    }

    public ParamsFilter llike() {
        this.type = "l-like";
        return this;
    }

    public ParamsFilter rlike() {
        this.type = "r-like";
        return this;
    }

    public ParamsFilter toDate(DateType dateType, int increase) {
        this.type = "to-date";
        this.dateType = dateType.getValue();
        this.increase = increase;
        this.timeUnit = TimeUnit.DAYS;
        return this;
    }

    public ParamsFilter toDate(DateType dateType, TimeUnit timeUnit, int increase) {
        this.type = "to-date";
        this.dateType = dateType.getValue();
        this.increase = increase;
        if (timeUnit != null) {
            this.timeUnit = timeUnit;
        }
        return this;
    }

    public ParamsFilter toNumber(String dataType) {
        this.type = "to-number";
        this.dataType = dataType.toLowerCase();
        return this;
    }

    public ParamsFilter toString(String addQuote) {
        this.type = "to-string";
        if (StringUtil.isBlank(addQuote) || "none".equalsIgnoreCase(addQuote)) {
            this.addQueto = "none";
        } else if ("\"".equals(addQuote) || "double".equalsIgnoreCase(addQuote)) {
            this.addQueto = "double";
        } else if ("'".equals(addQuote) || "single".equalsIgnoreCase(addQuote)) {
            this.addQueto = "single";
        }
        return this;
    }

    public ParamsFilter primary(String ... excludes) {
        this.type = "primary";
        this.excludes = excludes;
        return this;
    }

    public ParamsFilter clone(String aliasName) {
        this.type = "clone";
        this.asName = aliasName;
        return this;
    }

    public ParamsFilter between(Object startValue, Object endValue) {
        this.type = "between";
        this.value = new Object[]{startValue, endValue};
        return this;
    }

    public ParamsFilter defaultValue(Object defaultValue, String dataType) {
        this.type = "default";
        this.dataType = dataType == null ? "string" : dataType.toLowerCase();
        this.value = new Object[]{defaultValue};
        return this;
    }

    public ParamsFilter exclusive(Exclusive exclusive) {
        if (exclusive.getCompareType() == null || exclusive.getCompareValues() == null || exclusive.getUpdateParams() == null) {
            throw new IllegalArgumentException("filter exclusive \u5fc5\u987b\u8981\u8bbe\u7f6ecompareType\u3001compareValues\u3001updateParams\u5c5e\u6027\u503c!");
        }
        this.type = "exclusive";
        String string = this.compareType = exclusive.getCompareType() == null ? "==" : exclusive.getCompareType();
        if (this.compareType == "gte") {
            this.compareType = ">=";
        } else if (this.compareType == "gt") {
            this.compareType = ">";
        } else if (this.compareType == "lt") {
            this.compareType = "<";
        } else if (this.compareType == "lte") {
            this.compareType = "<=";
        } else if (this.compareType == "neq") {
            this.compareType = "!=";
        }
        this.compareValues = exclusive.getCompareValues();
        this.assignParams = exclusive.getUpdateParams();
        this.assignValue = exclusive.getUpdateValue();
        return this;
    }

    public ParamsFilter cacheArg(CacheArg cacheArg) {
        if (cacheArg.getCacheName() == null) {
            throw new IllegalArgumentException("cacheArg\u53cd\u5411\u7f13\u5b58\u5fc5\u987b\u8981\u8bbe\u7f6ecacheName\u5c5e\u6027!");
        }
        if (this.params.length > 1) {
            this.params = new String[]{this.params[0]};
        }
        this.type = "cache-arg";
        this.cacheArg = cacheArg;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String[] getParams() {
        return this.params;
    }

    public Object[] getValue() {
        return this.value;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public int getIncrease() {
        return this.increase;
    }

    public String getDateType() {
        return this.dateType;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getCompareType() {
        return this.compareType;
    }

    public String[] getCompareValues() {
        return this.compareValues;
    }

    public String getAssignValue() {
        return this.assignValue;
    }

    public String getAsName() {
        return this.asName;
    }

    public String[] getAssignParams() {
        return this.assignParams;
    }

    public String getAddQueto() {
        return this.addQueto;
    }

    public CacheArg getCacheArg() {
        return this.cacheArg;
    }
}

