/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.MetricRegistry;
import com.librato.metrics.HttpPoster;
import com.librato.metrics.LibratoReporter;
import com.librato.metrics.Sanitizer;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ryantenney.metrics.spring.reporter.AbstractScheduledReporterFactoryBean;
import com.ryantenney.metrics.spring.reporter.MetricPrefixSupplier;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class LibratoReporterFactoryBean
extends AbstractScheduledReporterFactoryBean<LibratoReporter> {
    public static final String USERNAME = "username";
    public static final String TOKEN = "token";
    public static final String PERIOD = "period";
    public static final String SOURCE = "source";
    public static final String SOURCE_SUPPLIER_REF = "source-supplier-ref";
    public static final String TIMEOUT = "timeout";
    public static final String NAME = "name";
    public static final String SANITIZER_REF = "sanitizer-ref";
    public static final String EXPANSION_CONFIG = "expansion-config";
    public static final String EXPANSION_CONFIG_REF = "expansion-config-ref";
    public static final String HTTP_POSTER_REF = "http-poster-ref";
    public static final String HTTP_CLIENT_CONFIG_REF = "http-client-config-ref";
    public static final String SOURCE_REGEX = "source-regex";
    public static final String DELETE_IDLE_STATS = "delete-idle-stats";
    public static final String OMIT_COMPLEX_GAUGES = "omit-complex-gauges";
    public static final String PREFIX_DELIMITER = "prefix-delimiter";
    public static final String CLOCK_REF = "clock-ref";
    public static final String DURATION_UNIT = "duration-unit";
    public static final String RATE_UNIT = "rate-unit";

    @Override
    public Class<LibratoReporter> getObjectType() {
        return LibratoReporter.class;
    }

    @Override
    protected LibratoReporter createInstance() {
        String username = this.getProperty(USERNAME);
        String token = this.getProperty(TOKEN);
        String source = this.hasProperty(SOURCE_SUPPLIER_REF) ? this.getPropertyRef(SOURCE_SUPPLIER_REF, MetricPrefixSupplier.class).getPrefix() : this.getProperty(SOURCE);
        LibratoReporter.Builder reporter = LibratoReporter.builder((MetricRegistry)this.getMetricRegistry(), (String)username, (String)token, (String)source);
        if (this.hasProperty(TIMEOUT)) {
            reporter.setTimeout(this.convertDurationString(this.getProperty(TIMEOUT)), TimeUnit.NANOSECONDS);
        }
        if (this.hasProperty(NAME)) {
            reporter.setName(this.getProperty(NAME));
        }
        if (this.hasProperty(SANITIZER_REF)) {
            reporter.setSanitizer(this.getPropertyRef(SANITIZER_REF, Sanitizer.class));
        }
        if (this.hasProperty(EXPANSION_CONFIG)) {
            LibratoReporter.MetricExpansionConfig config;
            String configString = this.getProperty(EXPANSION_CONFIG).trim().toUpperCase(Locale.ENGLISH);
            if ("ALL".equals(configString)) {
                config = LibratoReporter.MetricExpansionConfig.ALL;
            } else {
                String[] expandedMetricStrs;
                HashSet<LibratoReporter.ExpandedMetric> set = new HashSet<LibratoReporter.ExpandedMetric>();
                for (String expandedMetricStr : expandedMetricStrs = StringUtils.tokenizeToStringArray((String)configString, (String)",", (boolean)true, (boolean)true)) {
                    set.add(LibratoReporter.ExpandedMetric.valueOf((String)expandedMetricStr));
                }
                config = new LibratoReporter.MetricExpansionConfig(set);
            }
            reporter.setExpansionConfig(config);
        } else if (this.hasProperty(EXPANSION_CONFIG_REF)) {
            reporter.setExpansionConfig(this.getProperty(EXPANSION_CONFIG, LibratoReporter.MetricExpansionConfig.class));
        }
        if (this.hasProperty(HTTP_POSTER_REF)) {
            reporter.setHttpPoster(this.getPropertyRef(HTTP_POSTER_REF, HttpPoster.class));
        }
        if (this.hasProperty(HTTP_CLIENT_CONFIG_REF)) {
            reporter.setHttpClientConfig(this.getPropertyRef(HTTP_CLIENT_CONFIG_REF, AsyncHttpClientConfig.class));
        }
        if (this.hasProperty(DELETE_IDLE_STATS)) {
            reporter.setDeleteIdleStats(this.getPropertyRef(DELETE_IDLE_STATS, Boolean.TYPE).booleanValue());
        }
        if (this.hasProperty(OMIT_COMPLEX_GAUGES)) {
            reporter.setOmitComplexGauges(this.getPropertyRef(OMIT_COMPLEX_GAUGES, Boolean.TYPE).booleanValue());
        }
        reporter.setPrefix(this.getPrefix());
        if (this.hasProperty(PREFIX_DELIMITER)) {
            reporter.setPrefixDelimiter(this.getProperty(PREFIX_DELIMITER));
        }
        if (this.hasProperty(DURATION_UNIT)) {
            reporter.setDurationUnit(this.getProperty(DURATION_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(RATE_UNIT)) {
            reporter.setRateUnit(this.getProperty(RATE_UNIT, TimeUnit.class));
        }
        if (this.hasProperty(CLOCK_REF)) {
            reporter.setClock(this.getPropertyRef(CLOCK_REF, Clock.class));
        }
        if (this.hasProperty(SOURCE_REGEX)) {
            reporter.setSourceRegex(Pattern.compile(this.getProperty(SOURCE_REGEX)));
        }
        reporter.setFilter(this.getMetricFilter());
        return reporter.build();
    }

    @Override
    protected long getPeriod() {
        return this.convertDurationString(this.getProperty(PERIOD));
    }
}

